// AD5272 Verson 2.3

#include "AD5272.h"
#include "mbed.h"

AD5272::AD5272(PinName sda, PinName scl) : i2c(sda,scl)
{
    addresse=0x5E; //si GND > 0x5E | si NC > 0x5C
    i2c.frequency(100000);
}
void AD5272::initPot()
{
    char dataw[3];   
    dataw[0]=0x1C;
    dataw[1]=0x02;
    i2c.write(addresse, dataw, 2,0); 
}

unsigned short AD5272::getPot()
{
    char dataw[3];
    char datar[3];
    unsigned short valpot = 0;
    
    dataw[0]=0x08;
    dataw[1]=0x00;
    i2c.write(addresse, dataw, 2,1);
    i2c.read(addresse, datar, 2);
    
    return valpot; 
}

void AD5272::setPot(unsigned short v)
{
    char dataw[3];
    
    dataw[0] = 0x04;
    dataw[0] = (dataw[0]&0xFC)|((v>>8)&0x3);
    dataw[1] = v;
    
    i2c.write(addresse, dataw, 2,0);
    
}