#include "mbed.h"
#include "MCP23S17.h"
#define TOGGLE_BIT(REG,BIT) ((REG)^=(BIT))
//
// macro


//
Serial pc(PA_2, PA_3);  // I/O terminal PC
Serial bt(PA_9, PA_10); // I/O terminal PC
DigitalOut led(PA_15);  // led

SPI spi(PA_7, PA_6, PA_5);   // mosi miso clk
Ticker automate;
Ticker telemesure;
Timer voyant0;
Timer voyant1;
Timer voyant2;
Timer voyant3;
CAN can(PA_11,PA_12 );                   //canRX canTX
//expander
char Opcode = 0x40;
MCP23S17 chip = MCP23S17(spi, PF_1, Opcode);
DigitalOut reset(PA_4);   // reset expander

//CAN
CANMessage msg;            // message recu can
char tab[5]= {0x00,0xcc,0,0,0};   //
void send(void);
//
unsigned char leds=0xFF,flag_t=0;
//
void autom(void)
{
    //led=!led;
    send();
}
// fonction can en reception sur ISR
void rxcan()
{
    //pc.printf("receive\n");
    can.read(msg);
    if(msg.id==0x11) {
        led=!led;



        //CLEAR_BIT(leds,1);
        //leds=2;
        //chip.write(PORT_A, leds);
        switch (msg.data[0]) {
            case 0 :
                leds=chip.read(PORT_A);
                CLEAR_BIT(leds,1);
                chip.write(PORT_A, leds);
                break;
            case 1 :
                leds=chip.read(PORT_A);
                SET_BIT(leds,1);
                chip.write(PORT_A, leds);
                break;
            case 2 :
                voyant0.start();
                if(voyant0.read_ms()>100) {
                    voyant0.reset();
                    TOGGLE_BIT(leds,1);
                    chip.write(PORT_A, leds);
                }
                break;
            case 3 :
                voyant0.start();
                if(voyant0.read_ms()>1000) {
                    voyant0.reset();
                    TOGGLE_BIT(leds,1);
                    chip.write(PORT_A, leds);
                }
                break;
        }
        switch (msg.data[1]) {
            case 0 :
                leds=chip.read(PORT_A);
                CLEAR_BIT(leds,2);
                chip.write(PORT_A, leds);
                break;
            case 1 :
                leds=chip.read(PORT_A);
                SET_BIT(leds,2);
                chip.write(PORT_A, leds);
                break;
            case 2 :
                voyant1.start();
                if(voyant1.read_ms()>100) {
                    voyant1.reset();
                    TOGGLE_BIT(leds,2);
                    chip.write(PORT_A, leds);
                }
                break;
            case 3 :
                voyant1.start();
                if(voyant1.read_ms()>1000) {
                    voyant1.reset();
                    TOGGLE_BIT(leds,2);
                    chip.write(PORT_A, leds);
                }
                break;
        }
        switch (msg.data[2]) {
            case 0 :
                leds=chip.read(PORT_A);
                CLEAR_BIT(leds,4);
                chip.write(PORT_A, leds);
                break;
            case 1 :
                leds=chip.read(PORT_A);
                SET_BIT(leds,4);
                chip.write(PORT_A, leds);
                break;
                case 2 :
                voyant2.start();
                if(voyant2.read_ms()>100) {
                    voyant2.reset();
                    TOGGLE_BIT(leds,4);
                    chip.write(PORT_A, leds);
                }
                break;
            case 3 :
                voyant2.start();
                if(voyant2.read_ms()>1000) {
                    voyant2.reset();
                    TOGGLE_BIT(leds,4);
                    chip.write(PORT_A, leds);
                }
                break;
        }
        switch (msg.data[3]) {
            case 0 :
                leds=chip.read(PORT_A);
                CLEAR_BIT(leds,8);
                chip.write(PORT_A, leds);
                break;
            case 1 :
                leds=chip.read(PORT_A);
                SET_BIT(leds,8);
                chip.write(PORT_A, leds);
                break;
                case 2 :
                voyant3.start();
                if(voyant3.read_ms()>100) {
                    voyant3.reset();
                    TOGGLE_BIT(leds,8);
                    chip.write(PORT_A, leds);
                }
                break;
            case 3 :
                voyant3.start();
                if(voyant3.read_ms()>1000) {
                    voyant3.reset();
                    TOGGLE_BIT(leds,8);
                    chip.write(PORT_A, leds);
                }
                break;
        }
        //leds=msg.data[1]+;
        //chip.write(PORT_A, leds);
        //bt.printf("%0X\r",msg.data[0]);
        //bt.printf("%0X\r",chip.read(PORT_B));
    }
}
// fonction d'envoi trame de test can
void send()
{
    //pc.printf("send()\n");
    tab[1]=~chip.read(PORT_B);  // lecture des boutons et inversion
    while(!can.write(CANMessage(0x22, tab, 3)));
    // if(can.write(CANMessage(0x11, tab, 2))) {
    tab[0]++;
}
void telem()
{
    flag_t=1;
}
int main()
{
    automate.attach(&autom,1./10);
    telemesure.attach(&telem,1.0);
    can.frequency(1000000);
    can.attach(&rxcan);
    bt.baud(115200);   // vitesse bluetooth
    // RAZ expandeur de bus
    reset = 0;
    wait_us(1);
    reset = 1;
//
//  Set all 8 Port A bits to output direction
    chip.direction(PORT_A, 0x00);
//  Set all 8 Port B bits to input direction
    chip.direction(PORT_B, 0xFF);
    chip.configurePullUps(PORT_B, 0xFF);
    //pc.printf("Hello Viti2 \r\n");
    chip.write(PORT_A, leds);
    while(1) {
        if(flag_t) {
            bt.printf("led %02X, boutons %02X \n\r",leds, (unsigned char)(~chip.read(PORT_B)));
            flag_t=0;
        }
    }
}