#include "mbed.h"
#include "RFIDer.h"

RFIDer RFID_reader(SPI_SCK, SPI_MOSI, SPI_MISO);
Ticker loop;
char* tag;

bool flag = 0;

void ISR_loop(void){
    flag = 1;
}

int main() {
    RFID_reader.setComPeriod(40);
    // Clock crystal
    RFID_reader.setClockFrequency(8000000);
    RFID_reader.setSamplingTime(40);
    RFID_reader.startReadingTag();
    
    loop.attach(&ISR_loop, 0.5);
    
    while(1){
        if (flag){
            if(RFID_reader.isTagAvailable()){
                tag = RFID_reader.getTag();
                printf("ID: ");
                for (int i = 0 ; i <= 7 ; i++){
                    printf("0x%d ",tag[i]);
                }
                printf("\n\r");
                //RFID_reader.stopReadingTag();
            }
            //printf("Antenna Status = %s\n\r", RFID_reader.getAntennaStatus() ? "Failure" : "OK");
            //printf("F = %d\n\r", RFID_reader.getClockFrequency());
            //printf("Phase = %d\n\r", RFID_reader.readPhase());
            flag = 0;
        }
    }
}