#include "mbed.h"

typedef enum
{
    SYNC = 0,
    READY,
}DecoderState;

typedef enum
{
    IDLE = 0,           // Looking for '0111111111'
    READING,
    DONE,          
}TagReaderState;


class RFIDer{
    public :
    
    RFIDer(PinName clk, PinName mosi, PinName miso);
    
    void setSamplingTime(char ts);
    
    char getSamplingTime();
    
    void setComPeriod(short half_period);
    
    short getComPeriod();
    
    void setConfigPage(char mode, char data);
    
    char getConfigPage(char mode);
    
    void setClockFrequency(int frequency);
    
    int getClockFrequency();
    
    int getAntennaStatus();
    
    char readPhase();
    
    void startReadingTag();
    
    void stopReadingTag();
    
    char* getTag(void);
    
    bool isTagAvailable(void);
    
      
    private :
    
    char sendCmd(char cmd);
    
    void ISR_tag_reading(void);
    
    char decodeBit(int delay);
    
    char checkDataIntegrity(void);
    
    void decodeTag(void);
    
    // Serial Interface (SPI like)
    DigitalOut mosi;        // Ditital data ouput
    DigitalOut clk;         // Digital clock output
    DigitalIn miso;         // Digital data input
    InterruptIn data;       // Interrupt on digital input (tag decoder purpose)
    int clock_frequency;    // HTRC110 hardware crystal frequency
    short Tserial;            // uC serial communication half period [us]
    
    // Tag interface (raw demodulated data)
    Timer timer;        // Timer to decode data
    short Tdata;          // Half data rate period [us]
    char lastBit;       // 0/1/2(unknown)
    bool array[60];     // 64 bits minus 9 header bits are enough but decoder needs at least 55+1 bits.
    char tag[8];        // Last read tag (Id = 0xtag[i])
    bool tagAvailable;  // A tag has been read and not got
};