#include "mbed.h"

DigitalOut H1(LED1);
DigitalOut H2(LED2);
DigitalOut H3(LED3);
DigitalOut H4(LED4);

DigitalOut INH1 (p16);
DigitalOut INH2 (p17);
DigitalOut INL1 (p18);
DigitalOut INL2 (p19);

DigitalOut powerLED (p25);
InterruptIn syncIn(p5);

DigitalOut test (p5);

Serial XBEE(P4_22, P4_23); // tx, rx
Serial pc(USBTX, USBRX); // tx, rx


char c[20];
char temp;
bool start =0;
bool dataReady =0;
int digitCounter;
int receivedNumber;

int pulseONWidth = 100;
int pulseOFFWidth = 100;
int numberPulse = 30;
unsigned int mainPulseOffWidth = 1000;
int numberMainPulse = 10;
bool monoPhasic = false;
bool invertMonoPhasic = false;
bool sync = false;

int pulseCounter = 0;


bool stopActivate = false;

void IRE(){
    if (sync)
        if (monoPhasic)
            if (pulseCounter < numberMainPulse){
                powerLED = !powerLED ;
                for (int i =0; i < numberPulse; i++){
                    
                    INL1 = 1;
                    INH2 = 1;
                    
                    wait_us (pulseONWidth);
                        
                    INH2 = 0;
                    INL1 = 0;
                        
                     wait_us (pulseOFFWidth);
                }
                wait_us(mainPulseOffWidth);
            }
        else if (invertMonoPhasic)
            if (pulseCounter < numberMainPulse){
                powerLED = !powerLED ;
                for (int i =0; i < numberPulse; i++){
                    
                    INL2 = 1;
                    INH1 = 1;
                    
                    wait_us (pulseONWidth);
                        
                    INH1 = 0;
                    INL2 = 0;
                        
                     wait_us (pulseOFFWidth);
                }
                wait_us(mainPulseOffWidth);
            }                        
        else 
            if (pulseCounter < numberMainPulse){
                powerLED = !powerLED ;
                for (int i =0; i < numberPulse; i++){
                        
                    INH1 = 0;
                    INL2 = 0;                                       
                    
                    INL1 = 1;    
                    INH2 = 1;
                    
                      
                    wait_us (pulseONWidth);
                    
                    INH2 = 0;
                    INL1 = 0;                                       
                    
                    INL2 = 1;
                    INH1 = 1;
                    
                        
                    wait_us (pulseOFFWidth);
                }
                INH1 = 0;
                INL1 = 0;
                INH2 = 0;
                INL2 = 0;
                wait_us(mainPulseOffWidth);
            }
             
        INH1 = 0;
        INL1 = 0;
        INH2 = 0;
        INL2 = 0;
        powerLED = 1;
        XBEE.putc('x');
    
    } 
    pulseCounter ++;
    if (pulseCounter == numberMainPulse){
        INH1 = 0;
        INL1 = 0;
        INH2 = 0;
        INL2 = 0;
        powerLED = 1;
        XBEE.putc('x');
    }            
}

int main() {
    syncIn.rise(&IRE);
    
    powerLED = 1;
    
    INH1 = 0;
    INL1 = 0;
    INH2 = 0;
    INL2 = 0;
    pc.baud(9600);
    XBEE.baud(9600);
    
    
    pc.putc('x');
    pc.printf ("main ");
    while (1) {
        
        if(XBEE.readable()) {

            temp = XBEE.getc();


    
            if (temp =='A' || temp =='C' ||temp =='E' ||temp =='G' ||temp =='I' || temp =='K' || temp =='M' || temp =='O' || temp =='Q') {
                dataReady = 0;
                powerLED = !powerLED ;
                start = 1;
                for (int j=1; j< 20; j++)
                    c[j]= 48;
                c[0] =0;
                receivedNumber = 0;
                digitCounter=0;
            }
    
    
            if (start)
                if (temp =='B' || temp =='D' ||temp =='F' ||temp =='H' ||temp =='J' || temp =='L'|| temp =='N'|| temp =='P' || temp =='R') {
                    start= 0;
                    for (int j=1; j< 20; j++)
                        receivedNumber +=(c[j]-48)* pow(10.0,(digitCounter -(j+1)));
    
                    //switch was better just laziness 
                    if (temp == 'B'){
                        pulseONWidth = receivedNumber;
                        //pc.printf (" pulseONWidth    %d  ",pulseONWidth);
                        }
                    else if (temp == 'D') {
                        pulseOFFWidth = receivedNumber;
                        //pc.printf (" pulseOFFWidth   %d  ",pulseOFFWidth);
                        }
                    else if (temp == 'F') {
                        numberPulse = receivedNumber; 
                        //pc.printf (" numberPulse    %d  ",numberPulse);
                        }                       
                    else if (temp == 'H'){ 
                        mainPulseOffWidth = receivedNumber;
                        //pc.printf (" mainPulseOffWidth   %d  ",mainPulseOffWidth);
                        }                        
                    else if (temp == 'J'){ 
                        numberMainPulse = receivedNumber;
                        //pc.printf (" numberMainPulse    %d  ",numberMainPulse);
                        }
                    else if (temp == 'L'){ 
                        monoPhasic = receivedNumber;
                        pc.printf (" monoPhasic     %d  ",monoPhasic); 
                        }
                    else if (temp == 'N'){ 
                        invertMonoPhasic = receivedNumber;
                        pc.printf (" invertMonoPhasic     %d  ",invertMonoPhasic); 
                        }                              
                    else if (temp == 'R') {
                        sync = receivedNumber;
                        pc.printf (" sync     %d  ",sync); 
                        wait(1);
                        XBEE.putc('x');
                        powerLED = 1;
                    }                        
                    else if (temp == 'P'){
                        /*
                        pc.printf ("%d  ",pulseONWidth);
                        pc.printf ("%d  ",pulseOFFWidth);
                        pc.printf ("%d  ",numberPulse);
                        pc.printf ("%d  ",mainPulseOffWidth);
                        pc.printf ("%d  ",numberMainPulse); 
                        pc.printf ("%d  ",monoPhasic);
                        pc.printf ("%d  ",invertMonoPhasic);
                        pc.printf ("%d  ",sync);  */                       
                        if (!sync)
                        if (monoPhasic)
                            for (int j =0; j < numberMainPulse; j++){
                                powerLED = !powerLED ;
                                for (int i =0; i < numberPulse; i++){
                                    
                                    INL1 = 1;
                                    INH2 = 1;
                                    
                                    wait_us (pulseONWidth);
                                        
                                    INH2 = 0;
                                    INL1 = 0;
                                        
                                     wait_us (pulseOFFWidth);
                                }
                                wait_us(mainPulseOffWidth);
                            }
                        else if (invertMonoPhasic)
                            for (int j =0; j < numberMainPulse; j++){
                                powerLED = !powerLED ;
                                for (int i =0; i < numberPulse; i++){
                                    
                                    INL2 = 1;
                                    INH1 = 1;
                                    
                                    wait_us (pulseONWidth);
                                        
                                    INH1 = 0;
                                    INL2 = 0;
                                        
                                     wait_us (pulseOFFWidth);
                                }
                                wait_us(mainPulseOffWidth);
                            }                        
                        else 
                            for (int j =0; j < numberMainPulse; j++){
                                powerLED = !powerLED ;
                                for (int i =0; i < numberPulse; i++){
                                        
                                    INH1 = 0;
                                    INL2 = 0;                                       
                                    
                                    INL1 = 1;    
                                    INH2 = 1;
                                    
                                      
                                    wait_us (pulseONWidth);
                                    
                                    INH2 = 0;
                                    INL1 = 0;                                       
                                    
                                    INL2 = 1;
                                    INH1 = 1;
                                    
                                        
                                    wait_us (pulseOFFWidth);
                                }
                                INH1 = 0;
                                INL1 = 0;
                                INH2 = 0;
                                INL2 = 0;
                                wait_us(mainPulseOffWidth);
                            }
                             
                        INH1 = 0;
                        INL1 = 0;
                        INH2 = 0;
                        INL2 = 0;
                        powerLED = 1;
                        XBEE.putc('x');

                    }      
                } else {
                    c[digitCounter]=temp;
                    digitCounter++;
                }
        }
    }

}

