#include "Functions.h"


bool syncShockReady = false;

//Delivering the HFAC and Dfeb Shock
void Delivering (int amplitude, int duration)
{

    uint16_t sample = 0;
    double step= (amplitude*220)/duration;

    for(int HFAC_Count=1; HFAC_Count<= duration; ++HFAC_Count)
    {
        sample = (uint16_t)(offset + (step*HFAC_Count));
        HFAC.write_u16(sample);
        wait_us(500);
        
        //pc.printf("%d\r\n",duration - HFAC_Count);
        if((duration - HFAC_Count) == 11){
            led1 = 0;
            SyncOut = 1;
        }
        
        sample = (uint16_t)(offset - (step*HFAC_Count));
        HFAC.write_u16(sample);
        wait_us(500);
    }
    
    HFAC_Relay = 0;
    M_Relay = 1;
    R_Relay = 0;
    wait_ms(1);
    M_Relay = 0;
    SyncOut =0;
    shock = 0;
    HFAC.write_u16(offset);
    buttonLEDs(shockButtonRedLED, Disable);
    
}

//Delivering the HFAC and Dfeb Shock in the sync mode
void SyncDelivering()
{
    if (byPassStatus)
        Delivering (HFAC_Amplitude, HFAC_Duration);
    else
        Delivering (10, 100);

    wait_ms(1000);
}

//Check the by Pass mode "HFAC ON or OFF"
void checkByPass()
{
    wait_ms(100);
    if (byPassButton){
        LCD.putc('A');
        byPassStatus = false;
    }
    else{
        LCD.putc('B');
        byPassStatus = true;
    }
    led4 = !led4;
}

//Interrupt function for R wave fall time 
void  syncInFuncFall()
{
    wait_ms(100);
    if (syncShock){
            buttonLEDs(shockButtonGreenLED, Disable);
    }
}
//Interrupt function for R wave raise time (Also calculating the average of 
// HeartRateAvg samples of R wave signals
void syncInFunc()
{
   if (syncShock) 
        if(heartRateTimerStart){
            if (heartMeanCounter < HeartRateAvg){
                buttonLEDs(shockButtonGreenLED, Enable);
                heartRateTemp += heartRateTimer.read_us();
                //pc.printf("%d   ", heartMeanCounter); 
                heartMeanCounter ++;
            }
            else{
                syncShock = false;
                buttonLEDs(shockButtonRedLED, Enable);

                heartRate = heartRateTemp / HeartRateAvg;
                heartMeanCounter = 0;
                heartRateTemp = 0;
                int fireTime =  heartRate - ((HFAC_Duration*1000) % heartRate)- 013.8* HFAC_Duration - 23625;//- ( -0.011*HFAC_Duration + 45.278)-10; 
                //pc.printf("%d   ", heartRate);
                //pc.printf("%d   ", HFAC_Duration);
                //pc.printf("%d   ", fireTime); 
                deliverTimeout.attach_us(&SyncDelivering, fireTime);
                
            } 
            heartRateTimer.reset();
        }
        else{
            heartRateTimerStart = true;
            heartRateTimer.start();
            heartMeanCounter = 0;
        }

    
}

//Shock and Charge button LEDS
void buttonLEDs(int led, bool enable)
{
    switch (led) {
        case 0:
            if(enable) {
                shockRedLED = 1;
                shockGreenLED = 0;
            } else {
                shockRedLED = 0;
                shockGreenLED = 0;
            }
            break;
        case 1:
            if(enable) {
                shockRedLED = 0;
                shockGreenLED = 1;
            } else {
                shockRedLED = 0;
                shockGreenLED = 0;
            }
            break;
        case 2:
            if(enable) {
                chargeRedLED = 1;
                chargeGreenLED = 0;
            } else {
                chargeRedLED = 0;
                chargeGreenLED = 0;
            }
            break;
        case 3:
            if(enable) {
                chargeRedLED = 0;
                chargeGreenLED = 1;
            } else {
                chargeRedLED = 0;
                chargeGreenLED = 1;
            }
            break;
    }
}
