#include "mbed.h"

//Interface with the LCD with UART
Serial LCD(p9, p10);  // tx, rx
//Interface with the PC with UART
Serial pc(USBTX, USBRX); // tx, rx

DigitalOut valve(p21); //Port 6
DigitalOut pump(p22); // Port 8

AnalogOut speed(p18); //Port 7

AnalogIn temperatures(p15); 
AnalogIn ECG(p16); //Port 17

// PFC, Port11, Port12, Port3
//Select between temp sensors
BusOut tempSel(p12, p11);
BusOut templeds(LED3, LED4);

// read pressure sensor
AnalogIn pressure(p20); //Port 15

//Fan control should be PWM
DigitalOut fan1(p23); // Port 19
DigitalOut fan2(p24); // Port 20
DigitalOut fan3(p25); // Port 21

//valve sync from outside
DigitalIn sync(p29); // Port 9

//Enable the PFC
DigitalOut PFC_ENABLE(p14); 
DigitalIn PFW(p13);

//when the PFC module is setteled are something is wrong
InterruptIn LD_ENABLE(p17);

//Control the main Pump
DigitalOut LOAD(p26);


DigitalOut powerLed(LED1);
DigitalOut valveLed(LED2);

void enableFunc(){
    if(LD_ENABLE)
        powerLed = 1;
    else
        powerLed = 0;
    }

int freq = 60;
int amp = 50;
int dutyCycle = 50;
bool syncState = false;

char temp;
bool start =0;
bool dataReady =0;
int receivedNumber;
    

int main() {
    
    LD_ENABLE.mode(PullUp);
    
    //set hte baudrate 
    pc.baud(9600);
    LCD.baud(115200);
    
    // initit
    pump =0;
    powerLed = 0;
    valve =0;
    valveLed = 0;
    
    wait_ms(10);
    //Interupt  call back functions
    LD_ENABLE.rise(&enableFunc);
    LD_ENABLE.fall(&enableFunc);
    
    powerLed = 1;
    wait(1);
    powerLed = 0;
    PFC_ENABLE = 1;
    
    while(1) {
        /*
        for (int i =0; i<3; i++){
            templeds = i;
            tempSel = i;
            wait_ms(1000);
            pc.printf("\n\r %f",temperatures.read());
        }*/
        
        //check if there is meassage from LCD
        if(LCD.readable()) {

            temp = LCD.getc();

    
            if (temp =='A' || temp =='C' ||temp =='E' ||temp =='G' ||temp =='I') {
                dataReady = 0;
                //package is comming
                start = 1;
                receivedNumber = 0;
            }
    
    
            if (start)
                if (temp =='B' || temp =='D' ||temp =='F' ||temp =='H' ||temp =='J') {
                    //end of package 
                    start= 0;
    
                    //switch was better just laziness 
                    if (temp == 'B'){
                        //pc.printf (" LOAD    %d  ",receivedNumber);
                        if (receivedNumber){
                            valveLed = 1;
                            LOAD = 1;
                        } 
                        else {                             
                            valveLed = 0;
                            LOAD = 0;
                        }
                    }
                    else if (temp == 'D') {
                        syncState = receivedNumber; 
                        //pc.printf (" syncState    %d  ",syncState);
                        }                       
                    else if (temp == 'F'){ 
                        freq = receivedNumber;
                        //pc.printf (" freq   %d  ",freq);
                        }                        
                    else if (temp == 'H'){ 
                        amp = receivedNumber;
                        speed = amp /100.0;
                        //pc.printf (" amp    %d  ",amp);
                        }
                    else if (temp == 'J'){ 
                        dutyCycle = receivedNumber;
                        //pc.printf (" dutyCycle     %d  ",dutyCycle); 
                        }
  
                } else {
                    receivedNumber = temp;

                }
        }
        
            

    }
}
