#include "mbed.h"

DigitalOut vestA_led(LED1);
DigitalOut pistonU_led(LED3);
DigitalOut pistonD_led(LED4);

DigitalOut vestA (p18);
DigitalOut pistonU (p29);
DigitalOut pistonD (p30);

Serial pc(USBTX, USBRX); // tx, rx


char c[20];
char temp;
bool start =0;
bool dataReady =0;
int digitCounter;
int receivedNumber;

int pulseWidth = 1000;
int delayA = 0;
int delayPU = 500;
int delayPD = 0;
int DCA = 50;
int DCPU = 50;
int DCPD = 50;

Timer vestATimer;
Timer pistonUTimer;
Timer pistonDTimer;

Timeout vestATimeout;
Timeout pistonUTimeout;
Timeout pistonDTimeout;

bool vestAStatus = false;
bool pistonUStatus = false;
bool pistonDStatus = false;


int onWidthA = 500;
int offWidthA = 500;

int onWidthU = 500;
int offWidthU = 500;

int onWidthD = 500;
int offWidthD = 500;

void vestATimeoutFunc()
{
    vestA =1;
    vestA_led = 1;
    vestATimer.start();
    vestAStatus = true;
}

void pistonUTimeoutFunc()
{
    pistonD =1;
    pistonU_led = 1;
    pistonUTimer.start();
    pistonUStatus = true;
}

void pistonDTimeoutFunc()
{
    pistonU =1;
    pistonD_led = 1;
    pistonDTimer.start();
    pistonDStatus = true;
}



int main() {
    
    vestA_led = 0;
    pistonU_led = 0;
    pistonD_led = 0;
    
    vestA = 0;
    pistonU = 0;
    pistonD = 0;
    

    pc.baud(9600);
   
    
    pc.putc('x');
    while (1) {
        
        if ((!vestAStatus&&(vestATimer.read_ms() > offWidthA)) ||(vestAStatus&&(vestATimer.read_ms() > onWidthA))){
            if (vestAStatus){
                vestAStatus = false;
                vestA_led = 0;
                vestA = 0;
                }
            else{ 
                vestA_led = 1;
                vestA = 1;
                vestAStatus = true;
                }
            vestATimer.reset();
        } 
        
        
        if ((!pistonUStatus&&(pistonUTimer.read_ms() > offWidthU)) ||(pistonUStatus&&(pistonUTimer.read_ms() > onWidthU))){
            if (pistonUStatus){
                pistonUStatus = false;
                pistonU_led = 0;
                pistonD = 0;
                }
            else{ 
                pistonU_led = 1;
                pistonD = 1;
                pistonUStatus = true;
                }
            pistonUTimer.reset();
        }    
        
        if ((!pistonDStatus&&(pistonDTimer.read_ms() > offWidthD)) ||(pistonDStatus&&(pistonDTimer.read_ms() > onWidthD))){
            if (pistonDStatus){
                pistonDStatus = false;
                pistonD_led = 0;
                pistonU = 0;
                }
            else{ 
                pistonD_led = 1;
                pistonU = 1;
                pistonDStatus = true;
                }
            pistonDTimer.reset();
        } 
                               
        if(pc.readable()) {

            temp = pc.getc();
            if (temp =='Z'){
                vestATimer.stop();
                pistonUTimer.stop();
                pistonDTimer.stop();
                
                vestATimer.reset();
                pistonUTimer.reset();
                pistonDTimer.reset();
                
                
                vestATimeout.detach();
                pistonUTimeout.detach();
                pistonDTimeout.detach();
                 
                vestA_led = 0;
                pistonU_led = 0;
                pistonD_led = 0;
                
                vestA = 0;
                pistonU = 0;
                pistonD = 0;
                
                vestAStatus = false;
                pistonUStatus = false;
                pistonDStatus = false;

            }
                 
                

    
            if (temp =='A' || temp =='C' ||temp =='E' ||temp =='G' ||temp =='I' || temp =='K' || temp =='M' || temp =='O' || temp =='Q'|| temp =='S') {
                dataReady = 0;
                start = 1;
                for (int j=1; j< 20; j++)
                    c[j]= 48;
                c[0] =0;
                receivedNumber = 0;
                digitCounter=0;
            }
    
    
            if (start)
                if (temp =='B' || temp =='D' ||temp =='F' ||temp =='H' ||temp =='J' || temp =='L'|| temp =='N'|| temp =='P' || temp =='R'|| temp =='T') {
                    start= 0;
                    for (int j=1; j< 20; j++)
                        receivedNumber +=(c[j]-48)* pow(10.0,(digitCounter -(j+1)));
    
                    //switch was better just laziness 
                    if (temp == 'B'){
                        pulseWidth = receivedNumber;
                        //pc.printf (" pulseONWidth    %d  ",pulseONWidth);
                        }
                    else if (temp == 'D') {
                        delayA = receivedNumber; 
                        //pc.printf (" numberPulse    %d  ",numberPulse);
                        }                       
                    else if (temp == 'F'){ 
                        DCA = receivedNumber;
                        onWidthA = DCA * pulseWidth / 100;
                        offWidthA = (100-DCA) * pulseWidth / 100;
                        //pc.printf (" mainPulseOffWidth   %d  ",mainPulseOffWidth);
                        }                        
                    else if (temp == 'L'){ 
                        delayPU = receivedNumber;
                        //pc.printf (" invertMonoPhasic     %d  ",invertMonoPhasic); 
                        }
                    else if (temp == 'N'){ 
                        DCPU = receivedNumber;
                        onWidthU = DCPU * pulseWidth / 100;
                        offWidthU = (100-DCPU) * pulseWidth / 100;
                        //pc.printf (" monoPhasic     %d  ",monoPhasic); 
                        }
                    else if (temp == 'P'){ 
                        delayPD = receivedNumber;
                        //pc.printf (" invertMonoPhasic     %d  ",invertMonoPhasic); 
                        }
                    else if (temp == 'R'){ 
                        DCPD = receivedNumber;
                        onWidthD = DCPD * pulseWidth / 100;
                        offWidthD = (100-DCPD) * pulseWidth / 100;
                        //pc.printf (" monoPhasic     %d  ",monoPhasic); 
                        wait(1);
                        pc.putc('x');
                        }                     
                    else if (temp == 'T'){
                        /*
                        pc.printf ("%d  ",pulseWidth);
                        pc.printf ("%d  ",delayA);
                        pc.printf ("%d  ",DCA);
                        pc.printf ("%d  ",delayV);
                        pc.printf ("%d  ",DCV); 
                        pc.printf ("%d  ",delayPU);
                        pc.printf ("%d  ",DCPU);
                        pc.printf ("%d  ",delayPD);
                        pc.printf ("%d  ",DCPD);
                         
                        pc.printf ("%d", receivedNumber);
                        */
                        if (receivedNumber& (1<< 0))
                            vestATimeout.attach(&vestATimeoutFunc, delayA/1000.0);
                        if (receivedNumber& (1<< 1))
                            pistonUTimeout.attach(&pistonUTimeoutFunc, delayPU/1000.0);
                        if (receivedNumber& (1<< 2))
                            pistonDTimeout.attach(&pistonDTimeoutFunc, delayPD/1000.0);                           


                    }      
                } else {
                    c[digitCounter]=temp;
                    digitCounter++;
                }
        }
    }

}