#include "mbed.h"

//#define TEST_ULTRASONIC
#ifdef TEST_ULTRASONIC   
#include "ultrasonic.h"
#else
#include "hcsr04.h"
#endif


//#define USE_THREAD
#ifdef USE_THREAD
#include "rtos.h"
#endif

#define  CHECK_DISTANCE 1000

int sum_dist[3] = {0,}; //ryuhs74@20150712 - 
int avg_dist = 0; //ryuhs74@20150712 - 
int index_dist = 0; //ryuhs74@20150712 - 

Serial pc(USBTX, USBRX); // tx, rx

#ifdef USE_THREAD
int isRun_thread = 0;
Thread *pThread = NULL;

void camera_thread( void const* args)
{
    isRun_thread = 1;
    
    while(isRun_thread){
        //ryuhs74@20150713 START - TEST code 
        for(int i = 0; i<100;i++){
            wait(1);
        }        
        break;
        //ryuhs74@20150713 - TEST code END       
    }
    
    if( pThread != NULL ){
        pThread->terminate();
        pThread = NULL;
    }
    isRun_thread = 0;
    return;
}
#endif

void dist(int distance)
{
    //put code here to happen when the distance is changed
    pc.printf("Distance changed to %d mm\r\n", distance);
}


#ifdef TEST_ULTRASONIC
ultrasonic mu(D8, D9, .1, 1, &dist);    //Set the trigger pin to D8 and the echo pin to D9
//have updates every .1 seconds and a timeout after 1
//second, and call dist when the distance changes
#else
HCSR04 sensor(D12, D11); 
#endif

int main()
{
#ifdef TEST_ULTRASONIC
    pc.printf("Start ----> TEST_ULTRASONIC\n");
#else
    pc.printf("Start ----> HCSR04\n");
#endif
    
#ifdef TEST_ULTRASONIC
    mu.startUpdates();//start mesuring the distance
#endif

    while(1) {

        pc.printf("Before mu.checkDistance();\n");
        //Do something else here
#ifdef TEST_ULTRASONIC
        mu.checkDistance();     //call checkDistance() as much as possible, as this is where
#else
        long distance = sensor.distance(); 
#endif
        //the class checks if dist needs to be called.
        pc.printf("After mu.checkDistance();\n");
               
       //ryuhs74@20150712 START - 
        if( index_dist < 3){
            pc.printf("Before mu.getCurrentDistance();\n");
#ifdef TEST_ULTRASONIC
            sum_dist[index_dist] = mu.getCurrentDistance();
#else
            sum_dist[index_dist] = distance;
#endif
            pc.printf("sum_dist[index_dist(%d)] = %d\n", index_dist, sum_dist[index_dist]);
            index_dist ++;
        } else {
            pc.printf("Before index_dist( %d ) ", index_dist);
            index_dist = 0;
            pc.printf("After index_dist( %d )\n", index_dist);
            
            for(int i =0; i<3;i++){
                avg_dist += sum_dist[i];
            }
            
            //avg_dist /= avg_dist;
            
            if( avg_dist <= CHECK_DISTANCE ){
                #ifdef USE_THREAD
                if( isRun_thread == 0 ){
                    Thread thread(camera_thread);
                    
                    if( pThread == NULL)
                        pThread = (Thread*)&thread;
                    
                }
                #else
                #endif
                
            }
        }
        pc.printf("wait(1)\n");
        //ryuhs74@20150712 - END        
        wait(1.0); //ryuhs7474@20150713 - 초당 한번씩 딜레이를 준다          
    }
}
