/*
# coded by revival / uasonice (at) gmail.com
# DATE: 2015/08/09 / Sun Aug  9 23:55:31 KST 2015
#
# DESCRIPTION:
#       rev Camera utility
*/

#include "mbed.h"
#include "CameraC328.h"

#define DEBUG_TYPE 1
#define P_ uart.printf
#include "rev_config.h"

#include "rev_Camera.h"


#if defined(USE_CAMERA)
static FILE *fp_jpeg;

//CameraC328 cam(PA_14, PA_13, CameraC328::Baud14400);
//CameraC328::JpegResolution camResul;


/**
 * A callback function for jpeg images.
 * You can block this function until saving the image datas.
 *
 * @param buf A pointer to the image buffer.
 * @param siz A size of the image buffer.
 */
void cb_jpeg(char *buf, size_t szImage) {
    for (int i = 0; i < (int)szImage; i++) {
        fprintf(fp_jpeg, "%c", buf[i]);
    }
}

/**
 * Synchronizing.
 */
void revSync(CameraC328 *pH) {
    CameraC328::ErrorNumber err = CameraC328::NoError;

    if(pH == NULL) return;
    err = pH->sync();
    if (CameraC328::NoError == err) {
        DM_fLN("[ OK ] : CameraC328::sync");
    } else {
        DM_fLN("[FAIL] : CameraC328::sync (Error=%02X)", (int)err);
    }
}

/**
 * jpeg snapshot picture.
 * param strFile: "/fs/file01.jpg"
 * param resol  : CameraC328::JpegResolution640x480, CameraC328::JpegResolution320x240
 */
void revJpeg_snapshot(CameraC328 *pH, char *strFile, CameraC328::JpegResolution resol) {
    CameraC328::ErrorNumber err = CameraC328::NoError;

    if(pH == NULL) return;
    err = pH->init(CameraC328::Jpeg, CameraC328::RawResolution80x60, resol);
    if (CameraC328::NoError == err) {
        DM_fLN("[ OK ] : CameraC328::init");
    } else {
        DM_fLN("[FAIL] : CameraC328::init (Error=%02X)", (int)err);
    }

    fp_jpeg = fopen(strFile, "w");
    err = pH->getJpegSnapshotPicture(cb_jpeg);
    if (CameraC328::NoError == err) {
        DM_fLN("[ OK ] : CameraC328::getJpegPreview");
    } else {
        DM_fLN("[FAIL] : CameraC328::getJpegPreview (Error=%02X)", (int)err);
    }

    fclose(fp_jpeg);
}

/**
 * jpeg preview picture.
 * param strFile: "/fs/file01.jpg"
 * param resol  : CameraC328::JpegResolution640x480, CameraC328::JpegResolution320x240
 */
void revJpeg_preview(CameraC328 *pH, char *strFile, CameraC328::JpegResolution resol) {
    CameraC328::ErrorNumber err = CameraC328::NoError;

    if(pH == NULL) return;
    err = pH->init(CameraC328::Jpeg, CameraC328::RawResolution80x60, resol);
    if (CameraC328::NoError == err) {
        DM_fLN("[ OK ] : CameraC328::init");
    } else {
        DM_fLN("[FAIL] : CameraC328::init (Error=%02X)", (int)err);
    }

    fp_jpeg = fopen(strFile, "w");

    //err = pH->getJpegPreviewPicture(cb_jpeg);
    err = pH->getJpegSnapshotPicture(cb_jpeg);
    if (CameraC328::NoError == err) {
        DM_fLN("[ OK ] : CameraC328::getJpegPreview");
    } else {
        DM_fLN("[FAIL] : CameraC328::getJpegPreview (Error=%02X)", (int)err);
    }

    fclose(fp_jpeg);
}

#endif // defined(USE_CAMERA)

