/*
# coded by revival / uasonice (at) gmail.com
# DATE: 2015/08/10 / Mon Aug 10 00:01:54 KST 2015
#
# DESCRIPTION:
#       http file server
*/

#include "mbed.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"
#include <stdio.h>
#include <string.h>

#define DEBUG_TYPE 1
#define P_ uart.printf
#include "rev_config.h"

#include "rev_httpFile.h"

#if defined(USE_HTTP_FILE_SERVER)
//Serial uart(USBTX, USBRX);

//TCPSocketServer server;
//TCPSocketConnection client;

char buffer[HTTPD_MAX_REQ_LENGTH];
char httpHeader[HTTPD_MAX_HDR_LENGTH+1];
char fileName[HTTPD_MAX_FNAME_LENGTH+1];
char dirName[HTTPD_MAX_DNAME_LENGTH+1];
char *uristr;
char *eou;

FILE *fp;
int rdCnt;

//DigitalOut led1(LED1); //server listning status
//DigitalOut led2(LED2); //socket connecting status


void get_file(char* uri)
{
    DM_FLN("get_file %s", uri);
    char *lstchr = strrchr(uri, NULL) -1;
    if ('/' == *lstchr) {
        DM_FLN("Open directory /sd%s", uri);
        *lstchr = 0;
        sprintf(fileName, "/sd%s", uri);
        DIR *d = opendir(fileName);
        if (d != NULL) {
            sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            sprintf(httpHeader,"<html><head><title>Directory Listing</title></head><body><h1>%s Directory Listing</h1><ul>", uri);
            client.send(httpHeader,strlen(httpHeader));
            struct dirent *p;
            while((p = readdir(d)) != NULL) {
                sprintf(dirName, "%s/%s", fileName, p->d_name);
                DM_FLN("%s", dirName);
                DIR *subDir = opendir(dirName);
                if (subDir != NULL) {
                    sprintf(httpHeader,"<li><a href=\"./%s/\">%s/</a></li>", p->d_name, p->d_name);
                } else {
                    sprintf(httpHeader,"<li><a href=\"./image.html?%s\">%s</a></li>", p->d_name, p->d_name);
                }
                client.send(httpHeader,strlen(httpHeader));
            }
        }
        closedir(d);
        DM_FLN("Directory closed");
        sprintf(httpHeader,"</ul></body></html>");
        client.send(httpHeader,strlen(httpHeader));
    } else {
        char *strFind;
        sprintf(fileName, "/sd%s", uri);
        if((strFind = strstr(fileName, "?")) != NULL) *strFind = NULL; // remove parameter
        fp = fopen(fileName, "r");
        if (fp == NULL) {
            DM_FLN("File not found");
            sprintf(httpHeader,"HTTP/1.1 404 Not Found \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            client.send(uri,strlen(uri));
        } else {
            DM_FLN("Sending: header");
            sprintf(httpHeader,"HTTP/1.1 200 OK\r\nContent-Type: text/html\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            DM_FLN(" file");
            while ((rdCnt = fread(buffer, sizeof( char ), HTTPD_MAX_REQ_LENGTH, fp)) == HTTPD_MAX_REQ_LENGTH) {
                client.send(buffer, rdCnt);
                DM_(".");
            }
            client.send(buffer, rdCnt);
            fclose(fp);
            DM_FLN("done");
        }
    }
}

void fileServer(/*void const *data*/)
{
    int ret;

    //DM_FLN("Wait for new connection...");
    ret = server.accept(client);
    if(ret < 0) return;
    client.set_blocking(false, 1500); // Timeout after 1500ms

    DM_FLN("Connection from: %s", client.get_address());
    while (true) {
        led2 = true;
        int n = client.receive(buffer, sizeof(buffer));
        if (n <= 0) break;
        DM_FLN("Recieved Data: %d\r\n\r\n%.*s",n,n,buffer);
        if (n >= 1024) {
            sprintf(httpHeader,"HTTP/1.1 413 Request Entity Too Large \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
            client.send(httpHeader,strlen(httpHeader));
            client.send(buffer,n);
            break;
        } else {
            buffer[n]=0;
        }
        if (!strncmp(buffer, "GET ", 4)) {
            uristr = buffer + 4;
            eou = strstr(uristr, " ");
            if (eou == NULL) {
                sprintf(httpHeader,"HTTP/1.1 400 Bad Request \r\nContent-Type: text\r\nConnection: Close\r\n\r\n");
                client.send(httpHeader,strlen(httpHeader));
                client.send(buffer,n);
            } else {
                *eou = 0;
                get_file(uristr);
            }
        }
    }
    led2 = false;
    client.close();
    return;
}
#endif // defined(USE_HTTP_FILE_SERVER)



