/*
# coded by revival / uasonice (at) gmail.com
# DATE: 2015/08/10 / Mon Aug 10 21:21:36 KST 2015
#
# DESCRIPTION:
#       global config for project
#		
*/

#ifndef __REV_CONFIG_H__
#define __REV_CONFIG_H__

//////////////////////////////////////////////////////////////////////////
// define FEATURE
#define USE_SDCARD
#define USE_HTTP_FILE_SERVER
#define USE_CAMERA
#define USE_MEASURE_DISTANCE


//////////////////////////////////////////////////////////////////////////
// extern variable
extern Serial uart;
extern bool g_bInitDone;

//////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////
/* coded by revival / 2006/03/09 */
/* Debug Message Macro Naming issue
 * F : File Name
 * f : Function Name
 * L : Line Number
 * N : Enter Code; (\n) Line feed
*/
#if defined(DEBUG_TYPE)
#define _F_ __FILE__
#define _f_ __FUNCTION__
#define _L_ __LINE__
#define _N_ "\r\n"

////////////////////////////
// define the Message Header
#define M_F    "[%s] ", _F_
#define M_Ff   "[%s:%s] ", _F_, _f_
#define M_FfL  "[%s:%s:%d] ", _F_, _f_, _L_
#define M_FL   "[%s:%d] ", _F_, _L_
#define M_f    "[%s] ", _f_
#define M_fL   "[%s:%d] ", _f_, _L_
#define M_L    "[%d] ", _L_

#if DEBUG_TYPE == 1
# ifndef P_
#  define P_ printf
# endif
# define DM_(fmt...)       P_(fmt)
# define DM_F(fmt...)      P_(M_F), P_(fmt)
# define DM_Ff(fmt...)     P_(M_Ff), P_(fmt)
# define DM_FfL(fmt...)    P_(M_FfL), P_(fmt)
# define DM_FfLN(fmt...)   P_(M_FfL), P_(fmt), P_(_N_)
# define DM_FfN(fmt...)    P_(M_Ff), P_(fmt), P_(_N_)
# define DM_FL(fmt...)     P_(M_FL), P_(fmt)
# define DM_FLN(fmt...)    P_(M_FL), P_(fmt), P_(_N_)
# define DM_FN(fmt...)     P_(M_F), P_(fmt), P_(_N_)

# define DM_f(fmt...)      P_(M_f_), P_(fmt)
# define DM_fL(fmt...)     P_(M_fL), P_(fmt)
# define DM_fLN(fmt...)    P_(M_fL), P_(fmt), P_(_N_)
# define DM_fN(fmt...)     P_(M_f), P_(fmt), P_(_N_)
# define DM_L(fmt...)      P_(M_L), P_(fmt)
# define DM_LN(fmt...)     P_(M_L), P_(fmt), P_(_N_)
# define DM_N(fmt...)      P_(fmt), P_(_N_)
# else // DEBUG_TYPE
#  define DM_(fmt...)
#  define DM_F(fmt...)
#  define DM_Ff(fmt...)
#  define DM_FfL(fmt...)
#  define DM_FfLN(fmt...)
#  define DM_FfN(fmt...)
#  define DM_FL(fmt...)
#  define DM_FLN(fmt...)
#  define DM_FN(fmt...)

#  define DM_f(fmt...)
#  define DM_fL(fmt...)
#  define DM_fLN(fmt...)
#  define DM_fN(fmt...)
#  define DM_L(fmt...)
#  define DM_LN(fmt...)
#  define DM_N(fmt...)
#endif // DEBUG_TYPE

#endif

#endif // __REV_CONFIG_H__

