#include "mbed.h"
#include "EthernetInterface.h"
#include "SDFileSystem.h"
#include <stdio.h>
#include <string.h>

#define DEBUG_TYPE 1
#define P_ uart.printf
#include "rev_config.h"

#include "rev_Camera.h"
#include "rev_httpFile.h"
#include "rev_Hcsr04.h"


#define MAC     "\x00\x08\xDC\x11\x34\x78"
#define IP      "192.168.5.5"
#define MASK    "255.255.255.0"
#define GATEWAY "192.168.5.1"

#define HTTPD_SERVER_PORT   80


Serial uart(USBTX, USBRX); // tx, rx

#if defined(USE_SDCARD)
SDFileSystem sd(PB_3, PB_2, PB_1, PB_0, "sd"); // WIZwiki-W7500 
#endif // defined(USE_SDCARD)

#if defined(USE_HTTP_FILE_SERVER)
EthernetInterface eth;
TCPSocketServer server;
TCPSocketConnection client;
#endif // defined(USE_HTTP_FILE_SERVER)

#if defined(USE_CAMERA)
//CameraC328 cam(PA_14, PA_13, CameraC328::Baud14400);
CameraC328 *g_pCam;
#endif // defined(USE_CAMERA)

#if defined(USE_MEASURE_DISTANCE)
//HCSR04 sensor(D12, D11); 
HCSR04 *g_pHcsr; 
#define  CHECK_DISTANCE 50
#endif // defined(USE_MEASURE_DISTANCE)


DigitalOut led1(LED1); //server listning status
DigitalOut led2(LED2); //socket connecting status

DigitalOut myled_R(D7);
DigitalOut myled_G(D6);
DigitalOut myled_B(D5);

//////////////////////////////////////////////////////////////////////////
Ticker tickLed;

//////////////////////////////////////////////////////////////////////////
void ledTickfunc()
{
    led1 = !led1;
}

void LedSet(int nSet)
{
    myled_R = nSet;
    myled_G = nSet;
    myled_B = nSet;
}

//////////////////////////////////////////////////////////////////////////
int main()
{
    Timer tm1;
    char strFile[32];
    uint32_t cntImage=1;

    tickLed.attach(&ledTickfunc,0.5);
    //ledTickfunc();

    uart.baud(115200);
    
    DM_fLN("INIT DEVICE");
    LedSet(0);
#if defined(USE_SDCARD)
    // Check File System
    DM_fLN("Checking File System");
    DIR *d = opendir("/sd/");
    if (d != NULL) {
        DM_fLN("SD Card Present");
    } else {
        DM_fLN("SD Card Root Directory Not Found");
    }
#endif // defined(USE_SDCARD)

#if defined(USE_HTTP_FILE_SERVER)
    // EthernetInterface eth;
    DM_fLN("Init Ethernet");
    //eth.init(); //Use DHCP
    eth.init((uint8_t*)MAC,IP,MASK,GATEWAY);  //IP,mask,Gateway
    DM_fLN("Connecting");
    eth.connect();
    DM_fLN("IP Address is %s", eth.getIPAddress());

    // TCPSocketServer server;
    server.bind(HTTPD_SERVER_PORT);
    server.listen();
    DM_fLN("Server Listening");

    // FIXME: no work - non-block mode
    server.set_blocking(false, 1000);
#endif // defined(USE_HTTP_FILE_SERVER)

#if defined(USE_CAMERA)
    DM_fLN("Init camera C328");
    g_pCam = new CameraC328(PA_13, PA_14, CameraC328::Baud14400);
    //g_pCam = new CameraC328(PA_13, PA_14, CameraC328::Baud38400);
    revSync(g_pCam);
#if 0
    tm1.reset();
    tm1.start();
    revJpeg_snapshot(g_pCam, "/sd/test_shoot.jpg", CameraC328::JpegResolution640x480);
    tm1.stop();
    DM_fLN("time of capture: %d", tm1.read_ms());
#endif
#endif // defined(USE_CAMERA)
#if defined(USE_MEASURE_DISTANCE)
    g_pHcsr = new HCSR04(D12, D11);
#endif // defined(USE_MEASURE_DISTANCE)

    //tickLed.attach(&fileServer,1.2);

    DM_fLN("start main loop");
    while(1) {
        int dist_cm = 0;
#if defined(USE_MEASURE_DISTANCE)
        if( (dist_cm = get_distance(g_pHcsr)) < CHECK_DISTANCE ) 
#endif // defined(USE_MEASURE_DISTANCE)
        {
            DM_fLN("capture image: %d", dist_cm);
#if defined(USE_CAMERA)
            memset(strFile, 0, 32);
            sprintf(strFile, "/sd/file_%03d.jpg", cntImage++);
            LedSet(1);
            revJpeg_snapshot(g_pCam, strFile, CameraC328::JpegResolution640x480);
            LedSet(0);
#endif // defined(USE_CAMERA)
        }
#if 1
        fileServer();
#else   
        wait_ms(1000);
#endif
    }
    //return 0;
}
