#if !FEATURE_LWIP
    #error [NOT_SUPPORTED] LWIP not supported for this target
#endif

#include "mbed.h"
#include "EthernetInterface.h"
//#include "TCPServer.h"
//#include "TCPSocket.h"

#define HTTP_STATUS_LINE "HTTP/1.0 200 OK"
#define HTTP_HEADER_FIELDS "Content-Type: text/html; charset=utf-8"
#define HTTP_MESSAGE_BODY ""                                     \
"<html>" "\r\n"                                                  \
"  <body style=\"display:flex;text-align:center\">" "\r\n"       \
"    <div style=\"margin:auto\">" "\r\n"                         \
"      <h1>Hello World</h1>" "\r\n"                              \
"      <p>It works !</p>" "\r\n"                                 \
"    </div>" "\r\n"                                              \
"  </body>" "\r\n"                                               \
"</html>"

#define HTTP_RESPONSE HTTP_STATUS_LINE "\r\n"   \
                      HTTP_HEADER_FIELDS "\r\n" \
                      "\r\n"                    \
                      HTTP_MESSAGE_BODY "\r\n"

//EDIT Martin Zeitler
//Definieren der Netzwerkparameter

#define IPADDRESS "192.168.0.109"
#define NETMASK "255.255.255.0"
#define GATEWAY "192.168.0.1"
#define PORT_RECEIVE 2223

//EDIT END

int main()
{
    printf("Basic HTTP server example\n");
    
    EthernetInterface eth;
    eth.set_network(IPADDRESS,NETMASK,GATEWAY);
    eth.connect();
    
   
    
    printf("The target IP address is '%s'\r\n", eth.get_ip_address());
    
    UDPSocket socket;
    
    if(socket.open(&eth)!=0)
    {
        printf("Opening failed\r\n");
        while(1);
    }
    
    
    //EDIT
    //if(socket.bind(2223)!=0)
    if(socket.bind(PORT_RECEIVE)!=0)
    {
        printf("Binding failed\r\n");
        while(1);
    } 
    else 
    {
        printf("Binding service on Port '%d' \n", PORT_RECEIVE);    
    }
    //EDIT END
    
    
    char buf[256];
    SocketAddress sender;
    
    while (true)
    {
        int recBytes = socket.recvfrom(&sender,buf,256);
        printf("Received packet. Size: %d\r\n",recBytes);
        if(recBytes)
        {
            socket.sendto(sender,buf,recBytes);
            printf("Sent echo\r\n");
        }
        
    }
}