#include "mbed.h"
#include "SerialBuff.h"
#include "Timer.h"

DigitalOut drift1(LED1),drift2(LED2),drift3(LED3),drift4(LED4);
DigitalOut rod1(p23),rod2(p24),rod3(p25),rod4(p26),rod5(p27),rod6(p28),rod7(p29),rod8(p30);
DigitalIn reset1(p13);
AnalogIn sone1(p15),sone2(p16),sone3(p17),sone4(p18);

Ticker t1;

LocalFileSystem local("local");

Serial pc(USBTX, USBRX);


void alarm1(void);
void alarm2(void);
void alarm3(void);
void alarm4(void);
void blink1(void);
void blink2(void);
void blink3(void);
void blink4(void);
void logg(void);
void testlogg(void);
void reset(void);
void sekunder(void);
void passord(void);
void meny(void);
void status(void);
void linje1(void);

#define grense0 1                         // 3.3v
#define grense3 0.5                       // sone 1 0.5
#define grense2 0.662                     // sone 2 0.662
#define grense1 0.398                     // sone 1 og 2 0.398
#define blink 0.1
#define vindu 0.08

volatile unsigned int sek = 0,min = 0,hour = 0,dag = 0,stat_rod1,stat_rod2,stat_rod3,stat_rod4,stat_rod5,stat_rod6,stat_rod7,stat_rod8,stat_reset,passord_1,valg,reset2;


int main()
{
    reset1.mode(PullDown);
    passord();
    meny();
    t1.attach(&sekunder, 1.0);
    if(valg == 1) {
        while(1) {
            alarm1();
            alarm2();
            alarm3();
            alarm4();

            reset();
            wait (0.1);
        }
    }
}
void meny(void)
{

    printf("\r\n\r\nMeny\r\n\r\n");
    printf("Tast:\r\n");
    printf("1 starte systemet\r\n");
    printf("2 reset alarmen\r\n");
    printf("3 avslutte systemet\r\n");
    printf("4 status\r\n");
    scanf("%d",&valg);

    if(valg == 1) {

    } else if(valg == 2) {
        reset2 = 1;
    } else if(valg == 3) {
        passord();
    } else if(valg == 4) {
        status();
    } else {

    }
}



void linje1(void)
{
    printf("\r\nVelkommen til BitGuard 3.25.1");
}

void status(void)
{
    if(rod1 == 1) {
        printf("sløyfe 1\r\ndetektor 1 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
    }
    if (rod2 == 1) {
        printf("sløyfe 1\r\ndetektor 2 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
    }
    if(rod3 == 1) {
        printf("sløyfe 2\r\ndetektor 1 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
    }
    if(rod4 == 1) {
        printf("sløyfe 2\r\ndetektor 2 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
    }
    if(rod5 == 1) {
        printf("sløyfe 3\r\ndetektor 1 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
    }
    if(rod6 == 1) {
        printf("sløyfe 3\r\ndetektor 2 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
    }
    if(rod7 == 1) {
        printf("sløyfe 4\r\ndetektor 1 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);

    }
    if(rod8 == 1) {
        printf("sløyfe 4\r\ndetektor 2 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
    }
    if(reset1 == 0) {
        printf("alarmen har blitt resatt\r\n");
    } else {
        printf("\r\nalt er i orden, ingen alarm er utlost");
    }
    meny();
}
void passord (void)
{
    printf("Hei!\r\nvenligst tast inn passord\r\n");
    scanf("%d", &passord_1);
    while (passord_1 != 258456) {
        printf("passord du har tastet inn er feil \r\nvenligst prov igjen\r\n ");
        scanf("%d", &passord_1);
    }
    linje1();
}
void sekunder(void)
{
    sek++;
    min = sek / 60;
    sek = sek % 60;
    hour = min / 60;
    min %= 60;
    dag = hour / 24;
    hour %= 24;

}
void alarm1(void)
{
    if( (sone1 >=  (grense0 - vindu)) && (sone1 <= (grense0 + vindu))) {
        blink1();
        testlogg();
    } else if( (sone1 >=  (grense1 - vindu)) && (sone1 <= (grense1 + vindu))) {
        blink1();
        rod1 = 1;
        rod2 = 1;

    }   else if( (sone1 >=  (grense2 - vindu)) && (sone1 <= (grense2 + vindu))) {
        blink1();
        rod1 = 1;

    }   else {
        blink1();
        rod2 = 1;


    }



}




void alarm2(void)
{
    if((sone2 >=  (grense0 - vindu)) && (sone2 <= (grense0 + vindu))) {
        blink2();
        testlogg();
    } else if((sone2 >=  (grense1 - vindu)) && (sone2 <= (grense1 + vindu))) {
        blink2();
        rod3 = 1;
        rod4 = 1;
    }   else if((sone2 >=  (grense2 - vindu)) && (sone2 <= (grense2 + vindu))) {
        blink2();
        rod3 = 1;

    }   else {
        blink2();
        rod4 = 1;

    }


}

void alarm3(void)
{
    if( (sone3 >=  (grense0 - vindu)) && (sone3 <= (grense0 + vindu))) {
        blink3();
        testlogg();
    } else if( (sone3 >=  (grense1 - vindu)) && (sone3 <= (grense1 + vindu))) {
        blink3();
        rod5 = 1;
        rod6 = 1;
    }   else if( (sone3 >=  (grense2 - vindu)) && (sone3 <= (grense2 + vindu))) {
        blink3();
        rod5 = 1;
    }   else {
        blink3();
        rod6 = 1;

    }



}

void alarm4(void)
{
    if( (sone4 >=  (grense0 - vindu)) && (sone4 <= (grense0 + vindu))) {
        blink4();
        testlogg();
    } else if( (sone4 >=  (grense1 - vindu)) && (sone4 <= (grense1 + vindu))) {
        blink4();
        rod7 = 1;
        rod8 = 1;
    }   else if( (sone4 >=  (grense2 - vindu)) && (sone4 <= (grense2 + vindu))) {
        blink4();
        rod7 = 1;
    }   else {
        blink4();
        rod8 = 1;

    }



}
void blink1(void)
{
    if ( rod1 == 1||rod2 == 1) {
        drift1 = 1;
        wait(blink);
        drift1 = 0;
    } else {
        drift1 = 1;
    }
}

void blink2(void)
{
    if ( rod3 == 1||rod4 == 1) {
        drift2 = 1;
        wait(blink);
        drift2 = 0;
    } else {
        drift2 = 1;
    }
}

void blink3(void)
{
    if ( rod5 == 1||rod6 == 1) {
        drift3 = 1;
        wait(blink);
        drift3 = 0;
    } else {
        drift3 = 1;
    }
}

void blink4(void)
{
    if ( rod7 == 1||rod8 == 1) {
        drift4 = 1;
        wait(blink);
        drift4 = 0;
    } else {
        drift4 = 1;
    }
}
void reset(void)
{
    if (reset1 == 0 || reset2 == 1 ) {
        rod1=rod2=rod3=rod4=rod5=rod6=rod7=rod8=drift1=drift2=drift3=drift4 = 0 ;
    }
    reset2 = 0;
    // scanf("%d",&valg);
}


void testlogg(void)
{
    if(rod1||rod2||rod3||rod4||rod5||rod6||rod7||rod8 == 1) {
        logg();

    }
}


void logg(void)
{
    FILE *fp = fopen("/local/logg.txt", "a");
    if (fp == NULL) {
        pc.printf("Filfeil - avslutter\r\n");
        exit(1);
    }

    if(rod1 == 1 && stat_rod1 == 0 ) {
        fprintf(fp,"sløyfe 1\r\ndetektor 1 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
        stat_rod1 = 1;
    }
    if (rod2 == 1 && stat_rod2 == 0 ) {
        fprintf(fp,"sløyfe 1\r\ndetektor 2 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
        stat_rod2 = 1;
    }
    if(rod3 == 1 && stat_rod3 == 0 ) {
        fprintf(fp,"sløyfe 2\r\ndetektor 1 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
        stat_rod3 = 1;
    }
    if(rod4 == 1 && stat_rod4 == 0 ) {
        fprintf(fp,"sløyfe 2\r\ndetektor 2 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
        stat_rod4 = 1;
    }
    if(rod5 == 1 && stat_rod5 == 0 ) {
        fprintf(fp,"sløyfe 3\r\ndetektor 1 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
        stat_rod5 = 1;
    }
    if(rod6 == 1 && stat_rod6 == 0 ) {
        fprintf(fp,"sløyfe 3\r\ndetektor 2 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
        stat_rod6 = 1;
    }
    if(rod7 == 1 && stat_rod7 == 0 ) {
        fprintf(fp,"sløyfe 4\r\ndetektor 1 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
        stat_rod7 = 1;
    }
    if(rod8 == 1 && stat_rod8 == 0 ) {
        fprintf(fp,"sløyfe 4\r\ndetektor 2 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
        stat_rod8 = 1;
    }
    if(reset1 == 0 && stat_reset == 0) {
        fprintf(fp,"alarmen har blitt resatt\r\n");
        stat_reset = 1;
    }
    fclose(fp);
}