#include "ctype.h"

class SerialBuff : public Serial
{
public:
    enum BuffState {String_Empty, In_Progress, String_Complete};

    SerialBuff(int n, PinName tx, PinName rx)  : Serial (tx, rx) {
        size = n;
        line = new char[n];
        state = String_Empty;
        pos = 0;
    }

    SerialBuff() : Serial (USBTX, USBRX) {
        size = 80;
        line = new char[size];
        state = String_Empty;
        pos = 0;
    }

//    ~SerialBuff() {
//        delete[] line;
//    }

//    SerialBuff(const SerialBuff& other) {
//        //copy ctor
//    }

    int empty() {
        return (pos == 0);
    }

    int getState() { // check internal state for buffer
        return state;
    }

    int ready() { // complete line from serial input?
        return (state == String_Complete);
    }

    int full() { // more space in buffer ?
        return (pos == (size - 1));
    }

    void reset() { // reset input buffer
        pos = 0;
        state = 0;
        line[0] = '\0';
    }

    int fill();                // Fill up buffer from serial input
    void getBuffer(char *buf); // copy buffer
 
private:
    char *line; // Textbuffer
    int size;   // Size of Textbuffer
    int pos;    // Next position to be written
    int state;  // 0: NEW, 1: Buffer Ready to be read, 2: In progress
};

int SerialBuff::fill()   // Fill up buffer from serial input
{
    int c;
    while(this->readable()) {
        c = this->getc();
        if (state == String_Empty) { // NEW
            if (isspace(c)) {
                continue;
            } else {
                line[pos++] = c;
                state = In_Progress; // INSIDE
            }
        } else if(state == 1) {
            if (c == '\n' || c == '\r') {
                line[pos] = '\0';
                state = String_Complete; // COMPLETE;
            } else {
                line[pos++] = c;
            }
        }
    }
    return state;
}

void SerialBuff::getBuffer(char *buf)   // copy buffer
{
    if (state == String_Complete) {
        strcpy(buf, line);
    } else {
        *buf = '\0';
    }
}
