#include "mbed.h"
#include "SerialBuff.h"
#include "Timer.h"

DigitalOut drift1(LED1),drift2(LED2),drift3(LED3),drift4(LED4);
DigitalOut rod1(p23),rod2(p24),rod3(p25),rod4(p26),rod5(p27),rod6(p28),rod7(p29),rod8(p30);
DigitalIn reset1(p13);
AnalogIn sone1(p15),sone2(p16),sone3(p17),sone4(p18);

Ticker t1;

LocalFileSystem local("local");

Serial pc(USBTX, USBRX);

                    //alle funskjoner
void alarm1(void);
void alarm2(void);
void alarm3(void);
void alarm4(void);
void blink1(void);
void blink2(void);
void blink3(void);
void blink4(void);
void logg(void);
void testlogg(void);
void reset(void);
void sekunder(void);
void passord(void);
void menyles(void);
void menyprint(void);
void status(void);
void linje1(void);

#define grense0 1                         // 3.3v
#define grense3 0.5                       // sone 1 0.5
#define grense2 0.662                     // sone 2 0.662
#define grense1 0.398                     // sone 1 og 2 0.398
#define blink 0.1
#define vindu 0.08

volatile unsigned int sek = 0,min = 0,hour = 0,dag = 0,stat_rod1,stat_rod2,stat_rod3,stat_rod4,stat_rod5,stat_rod6,stat_rod7,stat_rod8,stat_reset,passord_1,valg,reset2;


int main()                                // Her er hoved programmet
{
    reset1.mode(PullDown);
    while(1) {
        passord();
        menyprint();
        t1.attach(&sekunder, 1.0);
        while(1) {
            alarm1();
            alarm2();
            alarm3();
            alarm4();
            menyles();

            if (valg == 1 || reset1 == 0) {
                reset2 = 1;
                reset();
            } else if (valg == 2) {
                pc.printf("\r\nDu er n\x86 logget ut\r\n");
                pc.printf("\r\nTakk for at benyttet deg av BitGaurd 3.25.1\r\n");
                reset2 = 1;
                reset();
                break;
            } else if(valg == 3) {
                pc.printf("\r\n\r\nStatus:\r\n");
                status();
            }
            reset();
            wait (0.1);
        }
    }
}

void menyles(void)
{
    int stat;

    valg = 0;
    if (pc.readable()) {
        stat = pc.scanf("%d",&valg);
        if (stat != 1) {
            valg = 0;
        }
        if (!(valg >= 1 && valg <= 3)) {
            pc.printf("\r\nFeil verdi!\r\n\r\nvenligst pr\x9Bv igjen\r\n");
        }
    }

}
void menyprint(void)                            //Hovedmeny
{

    printf("\r\n\r\nMeny\r\n\r\n");
    printf("Tast:\r\n");
    printf("1 reset alarmen\r\n");
    printf("2 avslutte systemet\r\n");
    printf("3 status\r\n");
}



void linje1(void)                               //
{
    printf("\r\nVelkommen til BitGuard 3.25.1");
}

void status(void)                               //Denne funskjonen skriver til tera term hvilke alarm som har gått
{
    if(rod1 == 1) {
        pc.printf("\r\nsl\x9Byfe 1\r\ndetektor 1 har sl\x86tt ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
    }
    if (rod2 == 1) {
        pc.printf("\r\nsl\x9Byfe 1\r\ndetektor 2 har sl\x86tt ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
    }
    if(rod3 == 1) {
        pc.printf("\r\nsl\x9Byfe 2\r\ndetektor 1 har sl\x86tt ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
    }
    if(rod4 == 1) {
        pc.printf("\r\nsl\x9Byfe 2\r\ndetektor 2 har sl\x86tt ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
    }
    if(rod5 == 1) {
        pc.printf("\r\nsl\x9Byfe 3\r\ndetektor 1 har sl\x86tt ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
    }
    if(rod6 == 1) {
        pc.printf("\r\nsl\x9Byfe 3\r\ndetektor 2 har sl\x86tt ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
    }
    if(rod7 == 1) {
        pc.printf("\r\nsl\x9Byfe 4\r\ndetektor 1 har sl\x86tt ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
    }
    if(rod8 == 1) {
        pc.printf("\r\nsl\x9Byfe 4\r\ndetektor 2 har sl\x86tt ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
    }

    if(rod1==0&&rod2==0&&rod3==0&&rod4==0&&rod5==0&&rod6==0&&rod7==0&&rod8 == 0) {
        pc.printf("\r\nAlt er i orden, ingen alarm er utl\x9Bst");
    }
    menyprint();
}
void passord (void)                                 //Her må brukeren taste et oppgit passord for å få tilgang til alle mulighetene BitGuard 3.25.1 tilbyr
{
    printf("\r\nHei!\r\nvenligst tast inn passord for \x86 sette i gang alarmen\r\n");
    scanf("%d", &passord_1);
    while (passord_1 != 258456) {
        printf("\r\nPassordet du har tastet inn er feil \r\nVenligst pr\x9Bv igjen\r\n ");
        scanf("%d", &passord_1);
    }
    linje1();
}
void sekunder(void)                                 //tid taker funksjon
{
    sek++;
    min = sek / 60;
    sek %= 60;
    hour = min / 60;
    min %= 60;
    dag = hour / 24;
    hour %= 24;

}
void alarm1(void)                                   //Her ser man testen på alarmen
{
    if( (sone1 >=  (grense0 - vindu)) && (sone1 <= (grense0 + vindu))) {
        blink1();
        testlogg();
    } else if( (sone1 >=  (grense1 - vindu)) && (sone1 <= (grense1 + vindu))) {
        blink1();
        rod1 = 1;
        rod2 = 1;

    }   else if( (sone1 >=  (grense2 - vindu)) && (sone1 <= (grense2 + vindu))) {
        blink1();
        rod1 = 1;

    }   else {
        blink1();
        rod2 = 1;


    }



}




void alarm2(void)
{
    if((sone2 >=  (grense0 - vindu)) && (sone2 <= (grense0 + vindu))) {
        blink2();
        testlogg();
    } else if((sone2 >=  (grense1 - vindu)) && (sone2 <= (grense1 + vindu))) {
        blink2();
        rod3 = 1;
        rod4 = 1;
    }   else if((sone2 >=  (grense2 - vindu)) && (sone2 <= (grense2 + vindu))) {
        blink2();
        rod3 = 1;

    }   else {
        blink2();
        rod4 = 1;

    }


}

void alarm3(void)
{
    if( (sone3 >=  (grense0 - vindu)) && (sone3 <= (grense0 + vindu))) {
        blink3();
        testlogg();
    } else if( (sone3 >=  (grense1 - vindu)) && (sone3 <= (grense1 + vindu))) {
        blink3();
        rod5 = 1;
        rod6 = 1;
    }   else if( (sone3 >=  (grense2 - vindu)) && (sone3 <= (grense2 + vindu))) {
        blink3();
        rod5 = 1;
    }   else {
        blink3();
        rod6 = 1;

    }



}

void alarm4(void)
{
    if( (sone4 >=  (grense0 - vindu)) && (sone4 <= (grense0 + vindu))) {
        blink4();
        testlogg();
    } else if( (sone4 >=  (grense1 - vindu)) && (sone4 <= (grense1 + vindu))) {
        blink4();
        rod7 = 1;
        rod8 = 1;
    }   else if( (sone4 >=  (grense2 - vindu)) && (sone4 <= (grense2 + vindu))) {
        blink4();
        rod7 = 1;
    }   else {
        blink4();
        rod8 = 1;

    }



}
void blink1(void)                               //Denne får sløyfe lyset til å blinke
{
    if ( rod1 == 1||rod2 == 1) {
        drift1 = 1;
        wait(blink);
        drift1 = 0;
    } else {
        drift1 = 1;
    }
}

void blink2(void)
{
    if ( rod3 == 1||rod4 == 1) {
        drift2 = 1;
        wait(blink);
        drift2 = 0;
    } else {
        drift2 = 1;
    }
}

void blink3(void)
{
    if ( rod5 == 1||rod6 == 1) {
        drift3 = 1;
        wait(blink);
        drift3 = 0;
    } else {
        drift3 = 1;
    }
}

void blink4(void)
{
    if ( rod7 == 1||rod8 == 1) {
        drift4 = 1;
        wait(blink);
        drift4 = 0;
    } else {
        drift4 = 1;
    }
}
void reset(void)                                            //reset funskjon
{
    if (reset1 == 0 || reset2 == 1 ) {
        rod1=rod2=rod3=rod4=rod5=rod6=rod7=rod8=drift1=drift2=drift3=drift4 = 0 ;
    }
    reset2 = 0;
}


void testlogg(void)                                         //Tester om det skal logges
{
    if(rod1||rod2||rod3||rod4||rod5||rod6||rod7||rod8 == 1) {
        logg();

    }
}


void logg(void)                                             //Lager en txt fil som det logges på
{
    FILE *fp = fopen("/local/logg.txt", "a");
    if (fp == NULL) {
        pc.printf("Filfeil - avslutter\r\n");
        exit(1);
    }

    if(rod1 == 1 && stat_rod1 == 0 ) {
        fprintf(fp,"sløyfe 1\r\ndetektor 1 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
        stat_rod1 = 1;
    }
    if (rod2 == 1 && stat_rod2 == 0 ) {
        fprintf(fp,"sløyfe 1\r\ndetektor 2 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
        stat_rod2 = 1;
    }
    if(rod3 == 1 && stat_rod3 == 0 ) {
        fprintf(fp,"sløyfe 2\r\ndetektor 1 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
        stat_rod3 = 1;
    }
    if(rod4 == 1 && stat_rod4 == 0 ) {
        fprintf(fp,"sløyfe 2\r\ndetektor 2 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
        stat_rod4 = 1;
    }
    if(rod5 == 1 && stat_rod5 == 0 ) {
        fprintf(fp,"sløyfe 3\r\ndetektor 1 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
        stat_rod5 = 1;
    }
    if(rod6 == 1 && stat_rod6 == 0 ) {
        fprintf(fp,"sløyfe 3\r\ndetektor 2 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
        stat_rod6 = 1;
    }
    if(rod7 == 1 && stat_rod7 == 0 ) {
        fprintf(fp,"sløyfe 4\r\ndetektor 1 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
        stat_rod7 = 1;
    }
    if(rod8 == 1 && stat_rod8 == 0 ) {
        fprintf(fp,"sløyfe 4\r\ndetektor 2 har slått ut etter %dsek %dmin %dtimer %ddager\r\n",sek,min,hour,dag);
        stat_rod8 = 1;
    }
    if(reset1 == 0 && stat_reset == 0) {
        fprintf(fp,"alarmen har blitt resatt\r\n");
        stat_reset = 1;
    }
    fclose(fp);
}