
#include "Sigfox.h"

bool Sigfox::ready() {
    _at->send("AT");
    return _at->recv("OK");
}
bool Sigfox::reset() {
    _at->send("AT$P=0");
    return _at->recv("OK");
}

/*bool Sigfox::send(const char *data, char* response) {
    // If require a response add plus in message
    if(response != NULL) {
        // Add request response data
        _at->send("AT$SF=%s,1", data);
        // Wait response from sigfox after send
        if(_at->recv("OK")) {
            // Wait return
            return _at->recv("RX=%[^\r]", response);
        }
        return false;
    } else {
        _at->send("AT$SF=%s", data);
        return _at->recv("OK");
    }    
}*/


bool Sigfox::send(const char *data) {
    // If require a response add plus in message
        // Add request response data
        _at->send("AT$SF=%s", data);
        // Wait response from sigfox after send
        return _at->recv("OK"); 
   
}

bool Sigfox::setKey(bool type) {
    _at->send("ATS410=%d", type);
    return _at->recv("OK");
}


bool Sigfox::setCwEU(uint8_t mode ,uint8_t power) {
    _at->send("AT$CW=868130000,%d,%d",mode,power);
    return _at->recv("OK");
}


bool Sigfox::setPower(uint8_t power) {
    _at->send("ATS302=%d", power);
    return _at->recv("OK");
}

bool Sigfox::setPowerMode(uint8_t power) {
    _at->send("AT$P=%d", power);
    return _at->recv("OK");
}

bool Sigfox::saveConfig() {
    _at->send("AT$WR");
    return _at->recv("OK");
}

void Sigfox::wakeup(DigitalInOut sig_rst, float time) {
    // Wake up sigfox
    sig_rst.output();
    sig_rst = 0;
    wait(time);
    // Set high impendance the sigfox reset pin
    sig_rst.input();
    wait(time);
}

char *Sigfox::getID() {
    char *id;
    id = new char[8+2+2];
    _at->send("AT$I=10");
    _at->read(id, 8+2+2);
    memcpy(&ID[0],&id[2],9);
    ID[9] = '\0';
    return &ID[0];
}

char *Sigfox::getPAC() {
    char *pac;
    pac= new char[16+2+2];
    _at->send("AT$I=11");
    _at->read(pac, 16+2+2);
    memcpy(&PAC[0],&pac[2],17);
    PAC[17] = '\0';
    return &PAC[0];
}

float Sigfox::getTemperature() {
    char buff[6];
    _at->send("AT$T?");
    _at->read(buff, 6);
    buff[5] = 0;
    return ((double)atoi(buff))/10;
}

sigfoxvoltage_t Sigfox::getVoltages() {
    sigfoxvoltage_t volt;
    char buff[12];
    _at->send("AT$V?");
    _at->read(buff, 12);
    char buff2[5];
    memset(buff2,0,5);
    memcpy(buff2, &buff[0], 4);
    volt.current = ((double)atoi(buff2))/1000;
    memset(buff2,0,5);
    memcpy(buff2, &buff[6], 4);
    volt.last = ((double)atoi(buff2))/1000;
    return volt;
}