#ifndef SIGFOX_H
#define SIGFOX_H

#include "ATParser.h"
#include "mbed.h"


typedef struct _sigfoxvoltage {
    double current;
    double last;
} sigfoxvoltage_t;

class Sigfox
{
    private:
    ATParser *_at;
    public:
    char *ID;
    char *PAC;
    
    public:
    Sigfox(ATParser &at) : _at(&at) {ID= new char[9];PAC= new char[17];};
    
    bool ready();
    bool reset();
    
    bool send(const char *data);
    /**
     * true = public
     * false = private
     */
    bool setKey(bool type);
    /**
     * mode = 0 / 1 
     * power = default 15 | 0 .. 15 
     */
    
    bool setCwEU(uint8_t mode ,uint8_t power=15 ) ;
    
    bool setPower(uint8_t power=15);
    
    bool setPowerMode(uint8_t power);
    
    void wakeup(DigitalInOut sig_rst, float time=0.2);
    
    bool saveConfig();
    
    char *getID();
    
    char *getPAC();
    
    sigfoxvoltage_t getVoltages();
    
    float getTemperature();
};

#endif  /* SIGFOX_H */