#include "mbed.h"
#include "Hexi_OLED_SSD1351.h"
#include "images.h"
#include "OLED_types.h"
#include "OLED_fonts.h"

/*
Bitmaps need to be formatted as 16bppRgb565, flipped vertically
and a 6 byte header needs to be appended at the start of the array.
Use the following tool to create arrays for images. 
https://github.com/MikroElektronika/HEXIWEAR/tree/master/SW/ResourceCollectionTool
It takes an image and outputs the array. It handles the flipping and the 6 byte header.  
Image needs to be converted outside the tool to fit the screen (96px by 96px).
*/

int main() {
    
    //Pointer for the image to be displayed    
    const uint8_t *image1;
    const uint8_t *image2;

    //Setting pointer location of the 96 by 96 pixel bitmap
    image1  = NXP_whole_bmp;
    
    //Setting pointer location of the 96 by 32 pixel bitmap
    image2  = NXP_banner_bmp;
    
    //Instantiate the SSD1351 OLED Driver    
    SSD1351 oled(PTB22,PTB21,PTC13,PTB20,PTE6, PTD15); // (MOSI,SCLK,POWER,CS,RST,DC)
    
    //Turn on the backlight of the OLED Display 
    oled.DimScreenON();

    while (true) {
    
        //Fill the screen with white to overwrite previous image
        oled.FillScreen(COLOR_WHITE);
        //Fill 96px by 96px Screen with 96px by 96px NXP Image starting at x=0,y=0
        oled.DrawImage(image1,0,0);
        
        Thread::wait(2000);
        
        //Fill the screen with white to overwrite previous image
        oled.FillScreen(COLOR_WHITE);
        //Draw 96px by 32px NXP Banner at the bottom by setting x =0,y=64(96-32)
        oled.DrawImage(image2,0,64);
        
        Thread::wait(2000);
          
        }
}

