//Melexis Infrared Thermometer MLX90614 Library

//*****************************************************************
//  Build : 27/10/16 Dave Clarke
//          Only read thermo data.
//
//  This program does not check CRC.
//  If you want to check CRC, please do it your self :)
//****************************************************************// 

#include "mlx90614.h"

MLX90614::MLX90614(I2C* i2c, uint8_t addr){

    this->i2caddress = addr;
    this->i2c = i2c; 
    
}


bool MLX90614::getTemp(float* temp_val){

    bool ch;                    // Check flag for ack
    char data[3];               // Raw data storage
    char ram[1] = {0x07};       // RAM address what temperature is stored
    char readaddr = 0xB5;       // Read Data address
    uint16_t  temp_thermo;
       
    ch = i2c->write(i2caddress, ram, 1, true); // ping i2c with address and RAM location
    if (ch) return false;                      // check for ack
    
    ch = i2c->read(readaddr, data , 3); // read raw temperature value
    if (ch) return false;               // check for ack

    temp_thermo |=  data[1] << 8;   // make MSB
    temp_thermo |=  data[0];        // make LSB

    *temp_val = ((float)temp_thermo * 0.02) - 273;  //Convert kelvin to degree Celsius
   
    return true;                            //load data successfully, return true 
}


