#include "mbed.h"
#include "FXAS21002.h"

/*  Check out the full featured example application for interfacing to the 
 *  Gyro device at the following URL
 *  https://developer.mbed.org/teams/ATT-Hackathon/code/Accel_Mag_Gyro_SensorStream_K64F_AGM01_M/
*/

DigitalOut led1(LED_GREEN);
Serial pc(USBTX, USBRX);

// Pin connections for Hexiwear
FXAS21002 gyro(PTC11,PTC10);
// Storage for the data from the sensor
float gyro_data[3];  float gyro_rms=0.0;


// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
int main() {
        
    gyro.gyro_config();
    while (true) {
    
      gyro.acquire_gyro_data_dps(gyro_data);
      pc.printf("Roll (G) %4.2f,\t Pitch (G) %4.2f,\t Yaw (G) %4.2f\r\n",gyro_data[0],gyro_data[1],gyro_data[2]);
      gyro_rms = sqrt(((gyro_data[0]*gyro_data[0])+(gyro_data[1]*gyro_data[1])+(gyro_data[2]*gyro_data[2]))/3);
      pc.printf("Gyroscope RMS %f \r\n\n",gyro_rms);
 
      led1 = !led1;
      Thread::wait(1000);
    }
}

