/*
* Bitmaps need to be formatted as 16bppRgb565, flipped vertically
* and a 6 byte header needs to be appended at the start of the array.
* Use the following tool to create arrays for images. 
* https://github.com/MikroElektronika/HEXIWEAR/tree/master/SW/ResourceCollectionTool
* It takes an image and outputs the array. It handles the flipping and the 6 byte header.  
* Image needs to be converted outside the tool to fit the screen 
* (Max Dimensions:96px by 96px).
*/

#include "mbed.h"
#include "Hexi_OLED_SSD1351.h"
#include "images.h"
#include "Hexi_KW40Z.h"

#define LED_ON      0
#define LED_OFF     1
   
void StartHaptic(void);
void StopHaptic(void const *n);

/* Instantiate the Click Relay pinout */
DigitalOut relay1(PTA10);
DigitalOut relay2(PTC4);

/* Instantiate the RGB LED and Haptic motor pinout */
DigitalOut redLed(LED1);
DigitalOut greenLed(LED2);
DigitalOut blueLed(LED3);
DigitalOut haptic(PTB9);

/* Instantiate the Hexi KW40Z Driver (UART TX, UART RX) */ 
KW40Z kw40z_device(PTE24, PTE25);

/* Instantiate the SSD1351 OLED Driver */
SSD1351 oled(PTB22,PTB21,PTC13,PTB20,PTE6, PTD15); // (MOSI,SCLK,POWER,CS,RST,DC)

/* Define timer for haptic feedback */
RtosTimer hapticTimer(StopHaptic, osTimerOnce);



int flag=0;

void ButtonLeft(void)
{
    StartHaptic();
    
    redLed      = LED_ON;
    greenLed    = LED_ON;
    blueLed     = LED_OFF;
    
    relay2 = !relay2;
    flag = 1;
}

void ButtonRight(void)
{
    StartHaptic();
    
    redLed      = LED_ON;
    greenLed    = LED_OFF;
    blueLed     = LED_OFF;    
    
    relay1 = !relay1;
    flag = 1;
}

void StartHaptic(void)
{
    hapticTimer.start(75);
    haptic = 1;
}

void StopHaptic(void const *n) {
    haptic = 0;
    hapticTimer.stop();
    redLed      = LED_OFF;
    greenLed    = LED_OFF;
    blueLed     = LED_OFF;
}

int main() {
    
    redLed      = LED_OFF;
    greenLed    = LED_OFF;
    blueLed     = LED_OFF;
    
    /* Pointer for the image to be displayed  */  
    const uint8_t *image1;
    const uint8_t *image2;
    const uint8_t *image3;

    /* Setting pointer location of the 96 by 96 pixel bitmap */
    image1  = Relay_OFF;
    image2  = Button_OFF;
    image3  = Button_ON;
    
    /* Turn on the backlight of the OLED Display */
    oled.DimScreenON();
    
    /* Register callbacks to application functions */
    kw40z_device.attach_buttonLeft(&ButtonLeft);
    kw40z_device.attach_buttonRight(&ButtonRight);
    
    /* Fill the screen with white to overwrite previous image */
    oled.FillScreen(COLOR_BLACK);
        
    /* Fill 96px by 96px Screen with 96px by 96px NXP Image starting at x=0,y=0 */
    oled.DrawImage(image1,0,0);

    while (true) 
    {
        
        if (flag == 1) 
        {
            if (relay2==0)  
                {
                /* Fill 96px by 96px Screen with 96px by 96px NXP Image starting at x=0,y=0 */
                oled.DrawImage(image2,9,25);
                }
            else 
                {
                /* Fill 96px by 96px Screen with 96px by 96px NXP Image starting at x=0,y=0 */
                oled.DrawImage(image3,9,25);
                }
            if (relay1==0) 
                {
                /* Draw 96px by 96px NXP Banner at the bottom by setting x =0,y=64(96-32)*/
                oled.DrawImage(image2,54,25);
                }
            else 
                {
                /* Draw 96px by 96px NXP Banner at the bottom by setting x =0,y=64(96-32)*/
                oled.DrawImage(image3,54,25);
                }
        flag = 0;
        }
        Thread::wait(50);
    }
}