#include "mbed.h"
#include "WS2812.h"
#include "PixelArray.h"

#define WS2812_BUF 96 // W2812_BUFF >/= NUM_COLORS * NUM_LEDS
#define NUM_COLORS 6
#define NUM_LEDS 16

// Pin connections
DigitalOut led1(LED_GREEN); // RGB LED
Serial pc(USBTX, USBRX); // Serial interface
WS2812 ws(PTB11, WS2812_BUF, 0, 5, 5, 0); // LED Driver

// Variables
int i, j, z;

// Fuctions
PixelArray px(WS2812_BUF);

int main()
{

    // use per-pixel intensity scaling
//    ws.useII(WS2812::PER_PIXEL); // Enable Pixel diming between first and last row
    ws.useII(WS2812::GLOBAL); // Pixel dimming disabled
    
    // set up the colours we want to draw with
    int colorbuf[NUM_COLORS] = {0x2f0000,0x2f2f00,0x002f00,0x002f2f,0x00002f,0x2f002f};
    
    // for each of the colours (j) write out 16 of them the pixels are written at the colour*16, plus the colour position all modulus 60 so it wraps around
    for (i = 0; i < WS2812_BUF; i++) {
        px.Set(i, colorbuf[(i / NUM_LEDS) % NUM_COLORS]);
    }

    // now all the colours are computed, add a fade effect using intensity scaling compute and write the II value for each pixel
    for (j=0; j<WS2812_BUF; j++) 
    {
        // px.SetI(pixel position, II value)
        px.SetI(j%WS2812_BUF, 0xf+(0xf*(j%NUM_LEDS)));
    }


    // Now the buffer is written, rotate it by writing it out with an increasing offset
    while (true) 
    {
        for (z=0; z<WS2812_BUF; z++) // Color updated from Top to Bottom
//        for (z=WS2812_BUF; z>=0; z--) // Color updated from Bottom to Top        
        {
            ws.write_offsets(px.getBuf(),z,z,z);
            Thread::wait(100);
        }
        led1 = !led1;
    }

}