/***********************
Declaración de #include
***********************/
#include "mbed.h"
#include "SoftPWM.h"
#include "Servo.h"
#include <rtos.h>


/**********************
Declaración de #define
**********************/
#define num_patas 6
#define num_servos 3


#define MOV_AV_COX_1 110
#define INICIO_COX_1 90
#define MOV_RE_COX_1 75

#define MOV_AV_FEM_1 115
#define INICIO_FEM_1 90
#define MOV_RE_FEM_1 65

#define MOV_AV_TIB_1 115
#define INICIO_TIB_1 90
#define MOV_RE_TIB_1 65


#define MOV_AV_COX_2 110
#define INICIO_COX_2 90
#define MOV_RE_COX_2 75

#define MOV_AV_FEM_2 115
#define INICIO_FEM_2 90
#define MOV_RE_FEM_2 65

#define MOV_AV_TIB_2 115
#define INICIO_TIB_2 90
#define MOV_RE_TIB_2 65


#define MOV_AV_COX_3 110
#define INICIO_COX_3 90
#define MOV_RE_COX_3 75

#define MOV_AV_FEM_3 115
#define INICIO_FEM_3 90
#define MOV_RE_FEM_3 65

#define MOV_AV_TIB_3 115
#define INICIO_TIB_3 90
#define MOV_RE_TIB_3 65


#define SERVO_COX 0
#define SERVO_FEM 1
#define SERVO_TIB 2


#define HOME 0
#define AVANZA 1
#define RETROCEDE 2


/**********************
//Declaración de pines
**********************/
PinName TX = PC_6;
PinName RX = PA_12;

PinName coxa_1 = PB_8;
PinName femur_1 = PB_9;
PinName tibia_1 = PB_7;

PinName coxa_2 = PA_0;
PinName femur_2 = PA_1;
PinName tibia_2 = PB_0;

PinName coxa_3 = PB_1;
PinName femur_3 = PA_3;
PinName tibia_3 = PA_2;

PinName coxa_4 = PA_5;
PinName femur_4 = PA_6;
PinName tibia_4 = PA_7;

PinName coxa_5 = PB_6;
PinName femur_5 = PA_9;
PinName tibia_5 = PA_8;

PinName coxa_6 = PB_10;
PinName femur_6 = PB_3;
PinName tibia_6 = PA_10;


/**************************
//Declaración de funciones
**************************/
void mueve_servo(SoftPWM* servo, int grados);
void mueve_pata(char pata, char pos);
void mueve_hexapodo(int type);