/*
ES200 Project 2 thread example
D Evangelista, 2018
Note that this uses mbed OS 5 vice OS 2. 
*/

#include "mbed.h"
#include "rtos.h"
#include "stdio.h"
#include "Motor.h"
#include "Servo.h"

// Declare some stuff
DigitalIn sw1(p19); // switch for activating motor 
DigitalIn sw2(p18); // switch for activating servo 
DigitalOut led1(LED1); // status LED for sw1
DigitalOut led2(LED2); // status LED for sw2
DigitalOut heartbeat(LED4); // heartbeat LED
Motor m(p26,p30,p29); 
Servo s1(p21);
Thread m_thread; // NEW IN mbed OS 5, threads are used to (sorta) do multiple things at once
Thread s1_thread;

/** Callback for executing a simple motor action. When sw1 is high,
 *  the motor turns forward, otherwise the motor turns off.
 */
void m_callback(void); // This function will be run within the corresponding thread

/** Simple callback for servo motion. When sw2 is high, the servo steps right,
 *  otherwise it steps left. If it hits the ends it stays there.
 */
void s1_callback(void);

// main() runs in its own thread in the OS
int main() {
    // startup things
    printf("ES200 Project 2 thread example\n");
    s1.calibrate(0.0009,90.0); // calibrate servo s1 once at startup
    m.speed(0.0); // set motor speed to zero at startup
    
    // start tasks
    printf("main thread running\n");
    m_thread.start(callback(m_callback)); // starts the motor thread going
    s1_thread.start(callback(s1_callback)); // starts the servo thread going
    
    // main loop
    while(1){
        heartbeat = !heartbeat; // blink heartbeat once a second
        //ThisThread::sleep_for(1000);
        Thread::wait(1000);
                
        // I don't have to do my motor or servo stuff here because they are
        // running in their own threads. 
        } // main loop
} // main()




void m_callback(void){
    printf("m_thread running\n");
    while(1) {
        if (sw1.read()){
            led1.write(1); // light a light for debugging purposes
            m.speed(0.7); // spin motor ahead
            }
            else {
                led1.write(0); 
                m.speed(0.0); // stop the shaft
                }
        //ThisThread::sleep_for(200); // this thread executes 5x a second
        Thread::wait(200); 
    } // while(1)
} // m_callback()
    
    
    
void s1_callback(void){
    printf("s1_thread running\n");    
    while(1){
        if (sw2.read()){
            led2.write(1); // light a light for debugging purposes
            s1.write(s1.read()+0.1); // move servo a step to right
            }
            else{
                led2.write(0); 
                s1.write(s1.read()-0.1); // move servo a step to left
                }
        //ThisThread::sleep_for(200); // this thread executes 5x a second
        Thread::wait(200); 
        } // while(1)
} // s1_callback()
