#include "mbed.h"
#include "Motor.h"
#include "Servo.h"

PwmOut speaker(p23); //Speaker Control //*** I changed this to 25.
BusOut myled(p5,p6,p7,p8,p11); //Data bus for LEDs
DigitalIn switch2(p16); //Switch 2
DigitalIn switch3(p17); //Switch 3
DigitalIn switch4(p18); //Switch 4
DigitalIn switch5(p19); //Switch 5
Motor motor1(p26,p29,p30); /// *** motor only seems to work on these pins. JP
Servo servo1(p21); //Flag Servo
Servo servo2(p22); //Salute Servo
int random;

int main()
{
    float servopos1=0.0; //Initializing servo position for servo1
    float servopos2=0.0; //Initializing servo position for servo2
    float motorspeed = 1; //Initializing motor speed
    int light=1; //Initializing value to be passed into LED bus
    float volume;

    while(1) {
        if((switch2==0)&&(switch3==0)&&(switch4)==0&&(switch5==0)) { //Turn off
            servopos1=0.0;
            servopos2=0.0;
            servo1=servopos1;
            servo2=servopos2;
            motor1.speed(0);
            speaker=0.0;
            light=0;
            myled=light;
        } else if((switch2==1)&&(switch3==0)&&(switch4==0)&&(switch5==0)) { //Flag raising, sounds, salute, lights
            light=1;
            speaker=0.25;
            wait(.5);
            speaker=.75;
            wait(.5);
            servopos1=.40; //Flag rotation
            servo1=servopos1;
            servo2=.5;
            if(servo1.read()==.40) {
                servo2=1.0;
            }
            while(light<32) { //Incrementing lights
                myled=light;
                light=(light*2)+1;
                wait(1.0/9.0);
            }
        } else if((switch2==0)&&(switch3==1)&&(switch4==0)&&(switch5==0)) { //Fan, lights, sounds
            motor1.speed(motorspeed); //Turns on Fan
            volume=25;
            for(light=1; light<16; light++) {
                myled=light;
                wait(.3);
                if((switch2==0)&&(switch3==0)&&(switch4==0)&&(switch5==0)) {
                    break;
                }
            }
            while(volume>0) { //Decreasing and Increasing volume in sequence
                volume=1;
                speaker = float(volume)/50.0;
                wait(.5);
                wait(.5);
                if(volume>0) {
                    volume-=2;
                } else if(volume<0) {
                    volume+=2;
                }

            }
        } else if((switch2==0)&&(switch3==0)&&(switch4==1)&&(switch5==0)) { //Siren, Building Lights
            // two tone police siren effect -  two periods or two frequencies
            speaker=0.25;
            wait(.5);
            speaker=.5;
            wait(.5);
            myled=light; //Increasing Lights
            light=(light*2)+1;
            wait(.5);
            if(light>=32) {
                light=1;
            }
        } else if((switch2==0)&&(switch3==0)&&(switch4==0)&&(switch5==1)) { //Salute and cut salute
            if(servopos2==0.0) {
                servopos2=.5;
                servo2=servopos2;
            }
        } else if(servopos2==.5) {
            servopos2=0;
            { //Cut salute
                servo2=servopos2;
            }
        }
    }
}






