#include "mbed.h"
#include "nRF24L01P.h"

#define CHANNELS_NUMBER 12 
#define CMD_VALUE 65535
#define CMD_GET_STATUS 1
#define CMD_INITIALIZE 2

#define RCV_TIMEOUT_MS 150

nRF24L01P radio(       PB_5,    // MOSI
                       PB_4,    // MISO
                       PB_3,    // SCK
                       PB_7,   // CSN
                       PB_6,    // CE
                       PB_8);   // IRQ


DigitalOut myled(PA_7);

AnalogIn CH1(PC_0);
AnalogIn CH2(PC_1);
AnalogIn CH3(PC_2);
AnalogIn CH4(PC_3);

Serial pc(PA_2, PA_3); // tx, rx

uint16_t channels[CHANNELS_NUMBER]; 
uint16_t buffer  [CHANNELS_NUMBER]; 

Timer t;
int timeOffsetMs=0;

int getSubmarineTimeMs(){
    return t.read_ms()+timeOffsetMs;    
}

void updateTimeOffset(int subTime){
    timeOffsetMs = subTime-t.read_ms();
}

void readChannels() {
    channels[0]=(uint16_t)(1024*CH1.read());
    channels[1]=(uint16_t)(1024*CH2.read());
    channels[2]=(uint16_t)(1024*CH3.read());
    channels[3]=(uint16_t)(1024*CH4.read());
}

bool isInitializated(uint16_t state) {
    if((state>>8) & 0x01) return true;
    return false;
}

void zeroBuffer(){
    memset(buffer, 0, sizeof(buffer));     
}

bool receiveBuffer(){
    radio.setReceiveMode();
    
    int startTime=t.read_ms();
    
    while( !radio.readable() && t.read_ms()-startTime < RCV_TIMEOUT_MS);
        
    if(radio.readable())
    {
        pc.printf("Availiable %d\r\n",radio.readable());
        zeroBuffer();
        int rxDataCnt = radio.read( NRF24L01P_PIPE_P0, (char*)buffer, sizeof( buffer ) );
            
            
        return true;
    }
    return false;
}

void askFor(uint16_t query) {
    zeroBuffer();
    buffer[0] = CMD_VALUE;
    buffer[1] = query;
    radio.setTransmitMode();
    int bytesWritten=radio.write( NRF24L01P_PIPE_P1, (char*)buffer, sizeof(buffer) );
        
    if (bytesWritten<sizeof(buffer)) {
            pc.printf("Cmd transmit error");
    } else {
            pc.printf("Sent %d bytes\r\n",bytesWritten);
    }
    
    
}

int main() {
    myled=0;
    pc.baud(115200);
    pc.format();
    pc.printf("Hello world\r\n");
    
    radio.setTxAddress(0xDEADBEEF0F);
    radio.setRxAddress(0xDEADC0DE0F);
    radio.setRfFrequency(2405);
    radio.setRfOutputPower(NRF24L01P_TX_PWR_MINUS_18_DB);
    radio.powerUp();
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  radio.getRfFrequency() );
    pc.printf( "nRF24L01+ Channel    : %d \r\n", (radio.getRfFrequency() - NRF24L01P_MIN_RF_FREQUENCY ) & 0x7F );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  radio.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", radio.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", radio.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", radio.getRxAddress() );
    radio.setTransmitMode();
    radio.setTransferSize( CHANNELS_NUMBER*sizeof(uint16_t) );
    radio.enable();
    
    for(int i=4;i>0;i--){
        myled=!myled;
        wait(0.5);    
    }
    
    t.start();
    
    while(1) {
        readChannels();
        radio.setTransmitMode();
         //pc.printf("Sent: %d bytes",radio.write( NRF24L01P_PIPE_P1, test, 1 ));
        int bytesWritten=radio.write( NRF24L01P_PIPE_P0, (char*)channels, 2*CHANNELS_NUMBER );
        
        if (bytesWritten<2*CHANNELS_NUMBER){
            pc.printf("Transmit error");
        }
        
        askFor(CMD_GET_STATUS);
        if (!receiveBuffer()) {
            pc.printf("Timeout\r\n",(char*)buffer);   
            myled=1; 
            continue;
        }
        myled=0;
        pc.printf("Received telemetry: %s\r\n",(char*)buffer);
        if (!isInitializated(buffer[0])){
            pc.printf("Need initialization\r\n");
            updateTimeOffset(buffer[1]);
            askFor(CMD_INITIALIZE);
            if (!receiveBuffer()) {
                pc.printf("Timeout\r\n",(char*)buffer);   
                continue; 
            }
            
        } else {
          
        }
        
        /*
        value & 0xff;
        (value >> 8) & 0xff;
        */
        //pc.printf("Telem %s\r\n",(char*)buffer);
    }
}
