#include "mbed.h"

//-------------------------------------------------------
//Title: main.cpp
//Author: Richard Beauchemin
//Date: 11/17/2014
//Description: Motherboard I2C communication test.
//-------------------------------------------------------

//-------------------------------------------------------
//Global Variables
I2C mI2C(p28,p27);
DigitalOut sendGenLED(LED1);
DigitalOut receiveLED(LED2);
DigitalOut sendSpecLED(LED3);
int dCardAddress = 0x02;
char sendMSG = 'Z';
char msg[2];
//-------------------------------------------------------

//-------------------------------------------------------
//Function Declarations
int writeCell(int,char*);
int writeRow(int,char[],int);
//-------------------------------------------------------

int writeCell(int address, char* data)
{
    return mI2C.write((address),data,1,0);  
}

int writeRow(int address, char data[], int length)
{
    int ACK = 1;
    while(length)
    {
        ACK &= writeCell(address,&data[length - 1]);
        length--;    
    }        
    return ACK;
}


int main() 
{
    sendGenLED = 0;
    receiveLED = 0;
    //mI2C.frequency(100000);
    int data = 0x0001;
    while(1) 
    {
        if(mI2C.write(data))
            sendGenLED = 1;
        if(!mI2C.write(dCardAddress,&sendMSG,1,0))
            sendSpecLED = 1;     
        mI2C.read((dCardAddress),msg,2,0);
        if(msg[0] || msg[1]) 
        {
            receiveLED = 1;
            msg[0] = 0;
            msg[1] = 0;
        }
        wait(0.5);
        sendGenLED = 0;
        receiveLED = 0;
        sendSpecLED = 0;       
    }
    /*receiveLED = writeRow(dCardAddress, msg, 6);
    while(1)
    {
        sendLED = 1;
        wait(0.2);
        sendLED = 0;
    }*/
}
