#ifndef DS3231_H
#define DS3231_H

#define TRUE 1
#define FALSE 0

#define SINGLE_BYTE 1

#define DS3231_ADDRESS      0x68<<1/*0xAE*/

#define SECONDS             0x00
#define MINUTES             0x01
#define HOURS               0x02
#define DAY                 0x03
#define DATE                0x04
#define MONTH_CENTURY       0x05
#define YEAR                0x06

#define ALARM_1_SECONDS     0x07
#define ALARM_1_MINUTES     0x08
#define ALARM_1_HOURS       0x09
#define ALARM_1_DAY_DATE    0x0A
#define ALARM_2_MINUTES     0x0B
#define ALARM_2_HOURS       0x0C
#define ALARM_2_DAY_DATE    0x0D

#define CONTROL             0x0E
#define CONTROL_STATUS      0x0F

#define AGING_OFFSET        0x10

#define MSB_OF_TEMP         0x11
#define LSB_OF_TEMP         0x12



class DS3231
{
public:
    DS3231(PinName sda, PinName scl);
    void readControl();
private:
    int readByte(uint8_t registerAddress);
    int *readBytes(uint8_t registerAddress,uint8_t numBytes);
    int writeByte(uint8_t registerAddress,uint8_t outBuffer);
//    int writeBytes(uint8_t registerAddress, uint8_t *outBuffer,uint8_t numBytes);

protected:

I2C *_DS3231;
 
    
};

#endif