#include "mbed.h"
#include "DS3231.h"

DS3231::DS3231(PinName sda,PinName scl)
{
    _DS3231 = new I2C(sda,scl) ;  
}

void DS3231::readControl()
{
    int *a;
    a = DS3231::readBytes(MSB_OF_TEMP,1);
    int b = *a;
    printf("Control: %d\r\n",b);
}



/*----------------------------------------- I2C Functions -----------------------------------------*/

int DS3231::readByte(uint8_t registerAddress)
{
    char address[1];
    address[0] = registerAddress;
    if(_DS3231 -> write(DS3231_ADDRESS,address,SINGLE_BYTE,1))
    {
        return -2;
    }
    else
    {
        uint8_t inBuffer[1];
        if(_DS3231 -> read(DS3231_ADDRESS,(char *)inBuffer,SINGLE_BYTE,0))
        {
            return -1;
        }
        else
        {
            return inBuffer[0];
        }
    }
}

int *DS3231::readBytes(uint8_t registerAddress, uint8_t numBytes)
{
    int g = -1;
    int *gPtr = &g;
        
    char address[1];
    address[0] = registerAddress;
    if(_DS3231 -> write(DS3231_ADDRESS,address,SINGLE_BYTE,TRUE))
    {
        return gPtr;
    }
    else
    {
        uint8_t inBuffer[numBytes];
        uint8_t *inBufferPtr = &inBuffer[0];
        if(_DS3231 -> read(DS3231_ADDRESS,(char *)inBuffer,numBytes,FALSE))
        {
            return gPtr;
        }
        else
        {
            printf("Inside: %d\r\n",inBuffer[0]);
            return (int *)inBufferPtr;
        }
    }
    
}

int DS3231::writeByte(uint8_t registerAddress,uint8_t outBuffer)
{
    char address[1];
    address[0] = registerAddress;
    if(_DS3231 -> write(DS3231_ADDRESS,address,SINGLE_BYTE,TRUE))
    {
        return 1;
    }
    else
    {    
    char buffer[1];
    buffer[0] = outBuffer;
        if(_DS3231 -> write(DS3231_ADDRESS,buffer,SINGLE_BYTE,FALSE))
        {
            return 1;
        }
        else
        {
            return 0;
        }
    }
}

//int DS3231::writeBytes(uint8_t registerAddress, uint8_t *outBuffer, uint8_t numBytes)
//{
//    if(_DS3231 -> write(DS3231_ADDRESS,(char *)registerAddress,SINGLE_BYTE,TRUE))
//    {
//        return 1;
//    }
//    else
//    {
//        if(_DS3231 -> write(DS3231_ADDRESS,(char *)outBuffer,numBytes,FALSE))
//        {
//            return 1;
//        }
//        else
//        {
//            return 0;
//        }
//    }