#ifndef POST_HANDLER_H
#define POST_HANDLER_H
#include "../HTTPRequestHandler.h"
#include "../HTTPRequestDispatcher.h"
 
#include <map>
using std::map;

#include <string>
using std::string;

 
//handles POST request
class PostHandler : public HTTPRequestHandler
{
    public:
        PostHandler(const char* rootPath, const char* path, TCPSocket* pTCPSocket);
        virtual ~PostHandler();
    
        static void mount(const string& fsPath, const string& rootPath);
        
        static inline HTTPRequestHandler* inst(const char* rootPath, const char* path, TCPSocket* pTCPSocket){return new PostHandler(rootPath, path, pTCPSocket);}
        
        virtual void doGet();
        virtual void doPost();
        virtual void doHead();
        
        virtual void onReadable();
        virtual void onWriteable();
        virtual void onClose();
        
    private:
        FILE* m_fp;
        bool m_err404;
        static map<string,string> m_lFsPath;private:
};

#endif
