/* 
SY202 Final Project
04 MAR 2014

Created by:
             MIDN 3/C Villemez
             MIDN 3/C DaCruz
             MIDN 3/C Wellmon

Resources:
            LCDR Hoffmeister
            MBED Cookbook

*/

#include "PostHandler.h"
#include "string.h"
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include "C12832_lcd.h"
#include <stdlib.h>

 
char* myData; 
 
PostHandler::PostHandler(const char* rootPath, const char* path, TCPSocket* pTCPSocket):HTTPRequestHandler(rootPath, path, pTCPSocket){
}
 
 
PostHandler::~PostHandler(){
}
 
void PostHandler::doGet(){
}
 
void PostHandler::doPost()
{
    
    //get post variables
    string _path = path();
    string _rootpath = rootPath();
    int _datalen = dataLen();
    
}
 
void PostHandler::doHead(){
}
 
void PostHandler::onReadable(){
    
    C12832_LCD lcd;
    Serial pcx(USBTX, USBRX);
    
    int _datalen = dataLen();       //read POST data length
    if(_datalen <= 1024){           //makes sure that submitted html data is less than size of the buffer
        char _read_data[1024] = {};
        
        //read POST data
        readData(_read_data, _datalen);
        myData = _read_data;
        
        pcx.printf("TYPED: %s", myData);
        
        writeData(_read_data, strlen(_read_data));    //required to call onReadable section
        
        LocalFileSystem local("local");
    
        /*******************************INPUT VALIDATION*******************************/   
        int u = 7;
        //checks the submission for values that aren't accepted. Denies everything but letters.
        while(u < strlen(myData)){
            if(iscntrl(myData[u]) !=0 || ispunct(myData[u])!=0 || isdigit(myData[u])!=0) { 
                pcx.printf("\nCONTROL VALUES FOUND\n");
                myData = "xxxxxxxsomeone entered bad code >:{\n";
            }
            u++;
        }
    
        /**************************END OF INPUT VALIDATION******************************/
    
        //Copies submitted string into another buffer to get rid of 'variablename=' at the beginning
    
        char final[1024] = {};
        int i = 7;
        int x = 0;
        while(i < (strlen(myData))) {             
            final[x] = myData[i];
            i++;
            x++;
        }
    
    
        //If submission =='new', copy data in the file that was appended to (myList.txt) and append it to a new file(log.txt). Delete myList.txt until new submission
    
        FILE * listFile;
        char copyData[] = "new";
        if(strcmp(copyData, final)== 0){
            int size = 1;
            int tsize = 1;
            FILE * history;
            listFile = fopen ("/local/myList.txt", "r");

            char * bufRead[tsize];

            history = fopen("/local/log.txt", "a");
            fprintf(history, "**********DAY MARKER**************\n\n");
          
            while (size) {
                size = fread(bufRead,1,1,listFile);
                fwrite (bufRead , 1, 1, history);
            }
            fprintf(history, "\n\n");
            fclose(listFile);
            fclose(history);
            remove("/local/myList.txt");
            lcd.cls();
            lcd.printf("     A New Sheet\n    Has Been Started\n      WAITING...");
        }
        else{                                             //Write submitted html data to file myList.txt
            listFile = fopen("/local/myList.txt", "a");
            fprintf(listFile, "%s \n", final);
            fclose(listFile);
            char * show = strcat(final, " signed TAPs");
            lcd.cls();
            lcd.printf("%s\n     WAITING...     ",show);
        }    
    }
}
 
void PostHandler::onWriteable(){  

close();}
 
 
void PostHandler::onClose(){
return;
}

