/* 
SY202 Final Project
04 MAR 2014

Created by:
             MIDN 3/C Villemez
             MIDN 3/C DaCruz
             MIDN 3/C Wellmon

Resources:
            LCDR Hoffmeister
            MBED Cookbook

*/



#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#include <stdio.h>
#include <string.h>
#include <HTTPRequestHandler.h>
#include "PostHandler.h"
#include "C12832_lcd.h"


C12832_LCD lcd;

EthernetNetIf eth;  
HTTPServer svr;
 
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);


LocalFileSystem fs("home.htm");

int main() {
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);
    return -1;
  }
  printf("Setup OK\n");

  lcd.printf("DaCruz | Wellmon | Villemez\n");
  lcd.printf ("Server IP: %d.%d.%d.%d\n", eth.m_ip[0], eth.m_ip[1], eth.m_ip[2], eth.m_ip[3]);
  printf("Server IP: %d.%d.%d.%d\n", eth.m_ip[0], eth.m_ip[1], eth.m_ip[2], eth.m_ip[3]);

  FSHandler::mount("/home.htm", "/");
 
  svr.addHandler<FSHandler>("/"); //Default handler
  svr.addHandler<PostHandler>("/list.htm");
  
  svr.bind(80);
  
  printf("Listening...\n");
    
  Timer tm;
  tm.start();

  //Listen indefinitely
  while(true)
  {
    Net::poll();
      led1=!led1;
      led2=!led2;
      led3=!led3;
      led4=!led4;
      
   }
  
  return 0;
}
