/*
--------------------------------------------------------------
---- DECLARACIONES DE LIBRERIAS 
--------------------------------------------------------------
*/
#include "mbed.h"
#include "PN532_SPI.h"
#include "NfcAdapter.h"
#include "USBSerial.h"
#include "UtilidadesNFC.h"

/*
--------------------------------------------------------------
---- DECLARACIONES DE VARIABLES GLOBALES
--------------------------------------------------------------
*/

//Declaracion de estados 
enum estados{
     espera = 0x00,
     leerTagID = 0x01,
        
    };

estados miestado;



// configurando pines del led RGB como salida
DigitalOut red (LED1);
DigitalOut green (LED2);
DigitalOut blue (PTC4);

//INICIALIZANDO PUERTO USB
USBSerial usb;

/*
--------------------------------------------------------------
---- ESTADOS
--------------------------------------------------------------
*/

void estadoEspera()
{
    //APAGAR LED RGB
    red = 1;
    green = 1;
    blue = 1;
    
    //VARIABLES LOCALES
    char bufferRecibido[10];
    char bufferLeer[10] = "leer";
    
    
    

    usb.scanf("%s", bufferRecibido);//LEE LOS DATOS DE ENTRADA POR CONSOLA
    usb.printf("\r\nUsted Escribio - |%s| \r\n ", bufferRecibido);//MUESTRA LOS DATOS RECIBIDOS 
    
    //DEPENDIENDO DE LOS DATOS RECIBIDOS SE ENVIA A UN ESTADO DETERMINADO 
    if(strcmp(bufferRecibido, bufferLeer) == 0)
    {
         miestado = leerTagID;
    }

    
}

void estadoLeer()
{
    int valorRetorno = 0;
    
    while(valorRetorno == 0)
    {
        valorRetorno = LeerTagNFC();    
        
    }
    miestado = espera;
}
 

/*
--------------------------------------------------------------
---- FUNCION MAIN PRINCIPAL
--------------------------------------------------------------
*/   

int main()
{    

    while(1)
    {
        
        switch(miestado)
        {
            case  espera:
            estadoEspera();
            break;
            
            case  leerTagID:
            estadoLeer();
            break;
      
        }
        
    }
    

    
}
