/*
--------------------------------------------------------------
---- DECLARACIONES DE LIBRERIAS 
--------------------------------------------------------------
*/
#include "mbed.h"
#include "PN532_SPI.h"
#include "NfcAdapter.h"
#include "PN532.h"
#include "USBSerial.h"
#include "UtilidadesNFC.h"

/*
--------------------------------------------------------------
---- DECLARACIONES DE EXTERNAS
--------------------------------------------------------------
*/
extern USBSerial usb;
extern DigitalOut red;
extern DigitalOut green;
extern DigitalOut blue;

/*
--------------------------------------------------------------
---- FUNCIONES
--------------------------------------------------------------
*/

//Funcion para Inicializar el Chip NFC PN532
NfcAdapter inicializarlector()
{
    //Se inicializa el modulo de comunicacion SPI en los pines D11 (MOSI), D12 (MISO) y D13(CLK)
    SPI spi(D11, D12, D13);
    //se selecciona el pin SS (slave selector)
    PN532_SPI pn532spi(spi, D10);
    //envia comandos para inicializar comunicacion con el chip
    NfcAdapter nfc(pn532spi);
    //configura el chip en modo lectura escritura
    nfc.begin();
    return nfc;
};


//Funcion para identificar si hay un TAG en el modulo, obtener su ID y leer mensajes en memoria 
int LeerTagNFC(){
   
    //FUNCION PARA CONFIGURAR EL MODULO NFC
    NfcAdapter nfc = inicializarlector();
 
     while (1) {

        usb.printf("\r buscando Tag NFC\n\r");
           
           
        if (nfc.tagPresent()) { //ESCANEA HASTA ENCONTRAR UN TAG
            usb.printf("\r Tag encontrado \n\r");
            unsigned int type1 = nfc.guessTagType(); //OBTIENE EL TIPO DE TAG
            NfcTag tag = nfc.read(); //LEE EL TAG
            if (type1 == TAG_TYPE_MIFARE_CLASSIC){
                red = 0;
                blue = 0;
                wait(0.5);
                }

            string id = tag.getUidString(); //OBTIENE EL ID DEL TAG 
            
            usb.printf("|id: %s|\n\r", id); 
            
            if (tag.hasNdefMessage()) { //INDICA SI EL TAG TIENE UN MENSAJE EN SU MEMORIA
            NdefMessage mensaje = tag.getNdefMessage();//OBTIENE EL MENSAJE DENTRO DEL TAG
            usb.printf("|Mensaje: %s|\n\r", mensaje); 
            }
            return 1;
        }
        wait(1);
    }   
}
