/*
--------------------------------------------------------------
---- DECLARACIONES DE LIBRERIAS 
--------------------------------------------------------------
*/
#include "mbed.h"
#include "PN532_SPI.h"
#include "NfcAdapter.h"
#include "USBSerial.h"
#include "UtilidadesNFC.h"

/*
--------------------------------------------------------------
---- DECLARACIONES DE VARIABLES GLOBALES
--------------------------------------------------------------
*/

//Declaracion de estados 
enum estados{
     espera = 0x00,
     leerTagID = 0x01,
     escribirTag = 0x02,
     emularTag = 0x03     
    };

estados miestado;

uint8_t ndefBuf[128]; //EL MENSAJE NO PUEDE SUPERAR LOS 128 CARACTERES.
char buffertexto[15];
// configurando pines del led RGB como salida
DigitalOut red (LED1);
DigitalOut green (LED2);
DigitalOut blue (PTC4);

//INICIALIZANDO PUERTO USB
USBSerial usb;

/*
--------------------------------------------------------------
---- ESTADOS
--------------------------------------------------------------
*/

void estadoEspera()
{
    //APAGAR LED RGB
    red = 1;
    green = 1;
    blue = 1;
    
    //VARIABLES LOCALES
    char bufferRecibido[10];
    char bufferLeer[10] = "leer";
    char bufferEscribir[10] = "escribir";
    char bufferEmular[10] = "emular";
    
    
    
    

    usb.scanf("%s", bufferRecibido);//LEE LOS DATOS DE ENTRADA POR CONSOLA
    usb.printf("\r\nUsted Escribio - |%s| \r\n ", bufferRecibido);//MUESTRA LOS DATOS RECIBIDOS 
    
    //DEPENDIENDO DE LOS DATOS RECIBIDOS SE ENVIA A UN ESTADO DETERMINADO 
    if(strcmp(bufferRecibido, bufferLeer) == 0)
    {
         miestado = leerTagID;
    }
    else if(strcmp(bufferRecibido, bufferEscribir) == 0)
    {
        miestado =  escribirTag;   
    }   
    else if(strcmp(bufferRecibido, bufferEmular) == 0){
        miestado = emularTag;   
    }    
    
}

void estadoLeer()
{
    int valorRetorno = 0;
    
    while(valorRetorno == 0)
    {
        valorRetorno = LeerTagNFC();    
        
    }
    miestado = espera;
}

void estadoEscribir()
{
   
    int valorRetorno1 = 0;
    
        while(valorRetorno1 == 0)
    {
        valorRetorno1 = escribirTagNFC();    
        
    }
    miestado = espera;
}    

void estadoEmular()
{
   
    int valorRetorno1 = 0;
    
        while(valorRetorno1 == 0)
    {
        valorRetorno1 = emularTagNFC();    
        
    }
    miestado = espera;
} 
/*
--------------------------------------------------------------
---- FUNCION MAIN PRINCIPAL
--------------------------------------------------------------
*/   

int main()
{    

    while(1)
    {
        
        switch(miestado)
        {
            case  espera:
            usb.printf("-----Esperando comando-----\r\n ");
            estadoEspera();
            break;
            
            case  leerTagID:
            estadoLeer();
            break;
            
            case  escribirTag:
            usb.printf("escriba una palabra \r\n");
            usb.scanf("%s", buffertexto);//LEE LOS DATOS DE ENTRADA POR CONSOLA
            usb.printf("\r\nUsted Escribio - |%s| \r\n ", buffertexto);//MUESTRA LOS DATOS RECIBIDOS 
            estadoEscribir();
            break;
            
            case emularTag:
            usb.printf("escriba una palabra \r\n");
            usb.scanf("%s", buffertexto);//LEE LOS DATOS DE ENTRADA POR CONSOLA
            usb.printf("\r\nUsted Escribio - |%s| \r\n ", buffertexto);//MUESTRA LOS DATOS RECIBIDOS 
            estadoEmular();
            break;      
        }
        
    }
    

    
}
