/*
--------------------------------------------------------------
---- DECLARACIONES DE LIBRERIAS 
--------------------------------------------------------------
*/
#include "mbed.h"
#include "PN532_SPI.h"
#include "NfcAdapter.h"
#include "USBSerial.h"


//INICIALIZANDO PUERTO USB
USBSerial usb;


// configurando pines del led RGB como salida
DigitalOut red (LED1);
DigitalOut green (LED2);
DigitalOut blue (PTC4);


//Se inicializa el modulo de comunicacion SPI en los pines D11 (MOSI), D12 (MISO) y D13(CLK)
SPI spi(D11, D12, D13);
//se selecciona el pin SS (slave selector)
PN532_SPI pn532spi(spi, D10);
//envia comandos para inicializar comunicacion con el chip
NfcAdapter nfc(pn532spi);


int main(){
    //configura el chip en modo lectura escritura
    nfc.begin();
    
    red = 1;
    green = 1;
    blue = 1;
    
    usb.printf("\r Escribir tag - \n\r ");
    
    while (1) {
        usb.printf("\r Coloque una etiqueta Mifare Classic NFC formateada en el lector \n\r");
        if (nfc.tagPresent()) {//ESCANEA HASTA ENCONTRAR UN TAG
            
            NdefMessage message = NdefMessage();
            message.addTextRecord("Mauricio");//ESCRIBE TEXTO PLANO EN EL TAG
            //message.addUriRecord("http://www.pizzaspiccolo.com.co/");//ESCRIBE UNA URL EN EL TAG
            
            bool success = nfc.write(message);//CONFIRMA CUANDO EL TAG ES ESCRITO CORRECTAMENTE
            if (success) {
                blue = 0;
                usb.printf("\r Trate de leer esta etiqueta con su telefono \n\r");        
                } 
            else {
                red = 0;
                usb.printf("\r no se escribio \n\r");
            }
            
        }

        wait(2);
        
        blue = 1;
        red = 1;
    }
    
    }