#include "mbed.h"
#include "PN532_SPI.h"
#include "snep.h"
#include "NdefMessage.h"
#include "USBSerial.h"
#include <string>


//INICIALIZANDO PUERTO USB
USBSerial usb;

uint8_t ndefBuf[128]; //EL MENSAJE NO PUEDE SUPERAR LOS 128 CARACTERES.

int main()
{

    
    //Se inicializa el modulo de comunicacion SPI en los pines D11 (MOSI), D12 (MISO) y D13(CLK)
    SPI spi(D11, D12, D13);
    //se selecciona el pin SS (slave selector)
    PN532_SPI pn532spi(spi, D10);
    //configura el chip en modo emulacion de tarjeta
    SNEP nfc(pn532spi);
  
     
    
    while (1) {
        usb.printf("\r ENVIANDO MENSAJE - \n\r ");
        NdefMessage message = NdefMessage();
        message.addTextRecord("Mauricio Arias L");//COMANDO UTILIZADO PARA ENVIAR TEXTO PLANO
        message.addUriRecord("http://www.pizzaspiccolo.com.co/");//COMANDO UTILIZADO PARA ENVIAR UNA URL
        int messageSize = message.getEncodedSize();//OBTIENE EL TAMAÑO TOTAL DEL MENSAJE (ENCABEZADO + TEXTO)
        if (messageSize > sizeof(ndefBuf)) {
            usb.printf("EL MENSAJE ES DEMASIADO GRANDE\r\n");

        } 
        message.encode(ndefBuf);//ENCAPSULA EL ENCABEZADO Y EL MENSAJE EN EL BUFFER
        if (0 >= nfc.write(ndefBuf, messageSize)) {//ESCRIBE EL MENSAJE EN UN DISPOSITIVO MOVIL COMPATIBLE
            usb.printf("FALLO\r\n");
        } else {
            usb.printf("MENSAJE ENVIADO\r\n");
        }
        
        wait(2);
    }
}