#include "mbed.h"
#include "SDFileSystem.h"
#include "stdio.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "NTPClient.h"


#include "RF24.h"
const uint64_t  ADDRESS = 0xF0F0F0F0F0F0F001L;

RF24            radio(A2, A3, A4, D4, D2);    // SPI5 mosi, miso, sck, csn, ce (irq unused)

struct MyData 
{
    uint8_t  board;
    uint8_t counter;
    uint8_t temperature;

};

MyData data;






EthernetInterface eth;
DigitalOut myled(LED1);
SDFileSystem sd("sd");

// trim '\n'
void ntrim(char *str)
{
    int i;
    for (i = 0; str[i] != 0; ++i);

    if (i > 0 && str[i - 1] == '\n')
        str[i - 1] = 0;
}


int main(void) { 
    
    int temp_array[1]; // Nur zum Test
    temp_array[0]= 123; // Nur zum Test
    temp_array[1]= 124;// Nur zum Test
    
    
    if (!radio.begin()) {
        printf("Failed to initialize nRF24L01. Check whether connected.\r\n");
        return -1;  // Exit the program
    }
    radio.setPALevel(RF24_PA_LOW);
    radio.setRetries(5, 15);
    radio.setPayloadSize(sizeof(MyData));
    radio.setAutoAck(true);
    radio.openReadingPipe(0, ADDRESS);  // use pipe 0 of this slave to receive messsages and send back auto acknowledge
    radio.startListening();
    
    
    
    sd.mount(); 
    FILE *fp;
    NTPClient ntp;
    char buff[64];
    
        if(eth.init()!=0)                    //for DHCP Server
    {
        //if(eth.init(IP,MASK,GATEWAY)!=0) { //for Static IP Address
        printf("EthernetInterface Initialize Error \r\n");

        while (1)
        {
           fprintf(fp,"EthernetInterface Initialize Error \r\n");
        }
    }
    if(eth.connect()!=0)
    {
        printf("EthernetInterface Connect Error \r\n");
        while (1)
        {
            fprintf(fp,"EthernetInterface Connect Error \r\n");
        }
    }
    
        
    int x;
     
     
     // for (x=1; x<6;x++){
         
         
         while (1) {
        
        printf("laeuft\r\n");
        wait(1);
         
            if (radio.available()) {
            radio.read(&data, sizeof(MyData)); // read message and send acknowledge back to the master
            //led = payload;
             
             printf("------------------------\r\n");
             printf("Received from Board: %d \r\n", data.board);

             printf( "counter: %d \r\n", data.counter);
             printf( "temperature: %d \r\n", data.temperature);
             printf( "board: %d \r\n", data.board);
             printf("------------------------\r\n\n");

            
        
    /*
     
     
       fp = fopen("/sd/test.txt", "a");
        
        if (fp == NULL)
        {
            printf("open error!!\r\n");
            while(1);
        }

        
//////////////////////////////////////// Ethernet connection for timestamp////////////////////////////////////////////////////////////////   
  //  printf("IP Address is %s\r\n", eth.getIPAddress());
  //  printf("NetMask is %s\r\n", eth.getNetworkMask());
  //  printf("Gateway Address is %s\r\n", eth.getGateway());
  //  printf("Ethernet Setup OK\r\n");
  //  printf("Getting time, 10s timeout. \r\n");
    
    
    
    //if (ntp.setTime("1.pool.ntp.org") == 0)
    if (ntp.setTime("ntp0.freenet.de") == 0)
    {
        time_t ctTime;
        ctTime = time(0);
        fprintf(fp,"Temperatur:%i; %s" , temp_array[0], ctime(&ctTime));
        
    }
    else
    {
        printf("Error getting time \r\n");
    }    
     fclose (fp); 
   
        
    } 
   
    
        fp = fopen("/sd/test.txt", "r");
        if (fp == NULL)
        {
            printf("open error!!\r\n");
            while(1);
        }
        // read text file
        char buf[1024];
        while (fgets(buf, sizeof(buf), fp) != NULL)
        {
            ntrim(buf);
            printf("%s\r\n", buf);
        }

        // file close
        fclose(fp);
        
        */
        }
        
}
}
