#include "RawSerial.h" 
#include "RawSerial.h"
#include "mbed.h"
#include "macro.h"
#include "mbed.h"
#include "MTSSerial.h"
#include "rtos.h"

int zigbee_flag;
extern Mutex my_mutex;
extern int device_buffer[8];

Serial log_serial(PA_2,PA_3);

void recv_cb();

/* wait to initialize zigbee devie */
void init_func()
{
    printf("\r.............Initializing ...............\n\r");
    wait(20);
}

void zigbee_func(int deviceId,int state)
{
    printf("device id is %d, state is %d\r\n", deviceId, state);
    /* PA_3 for transmission
     PA_2 for receiving */
    static int init =0;     
    if( init == 0){
        init++;
        init_func();
    }
    printf("\r.............Zigbee Initializing ...............\n\r");
    //if (deviceId == 1)
      //  wait(20);
    //else
        //wait(20);
    int i = 0;
    log_serial.baud(9600);
    unsigned char requestMsg[19];
    
    requestMsg[0] = START_BYTE;
    requestMsg[1] = 0x12;                   // Length
    requestMsg[2] = 0x01;                   // Packet type
   
    if(deviceId ==  Light_bulb)
        memcpy(&requestMsg[3], IEEE_SM1, 8);
    else if(deviceId == Light_lamp)
        memcpy(&requestMsg[3], IEEE_SM2, 8);
    else if (deviceId == Tv)
        memcpy(&requestMsg[3], IEEE_SM3, 8);
    else {
        printf("Invalid Device ID");
        return ;
    }
    requestMsg[11] = MSB(NETWORK_ADDRESS);
    requestMsg[12] = LSB(NETWORK_ADDRESS);
    requestMsg[13] = SOURCE_ENDPOINT;
    requestMsg[14] = MSB(CLUSTER_ID);
    requestMsg[15] = LSB(CLUSTER_ID);
    requestMsg[16] = MSB(PAYLOAD);
    requestMsg[17] = LSB(PAYLOAD);

    if( state == ON)
        requestMsg[18] = 0x01;
    else
        requestMsg[18] = 0x0;
      wait(5);
    for( i = 0 ; i < 19; i ++){
        log_serial.putc(requestMsg[i]);
    }
    if (deviceId == 1)
        wait(20);
    else
        wait(5);
} 



void zigbee_task(void const *args)
{
    printf("started zigbee task\r\n");
    int zigbee_buffer[8];
    int i;
    while (true) {
        if (zigbee_flag) {
            my_mutex.lock();
            for (i = 0; i < 2; i++)
                zigbee_buffer[i] = device_buffer[i];
            my_mutex.unlock();
            printf("zigbee_func called\r\n");
            zigbee_func(zigbee_buffer[0], zigbee_buffer[1]);
            zigbee_flag = 0;
        } 
        osDelay(1000);    
    }    
}
