#include "mbed.h"
#include "mDot.h"
#include "MTSLog.h"
#include <string>
#include <vector>
#include <algorithm>

mDot* dot;
void init_mdot(void)
{
    // get a mDot handle
    dot = mDot::getInstance();
    
    // print library version information
    //logInfo("version: %s", dot->getId().c_str());
    
    //logInfo("Test msg \n\r", dot->getId().c_str());
    
    //logInfo("Test msg \n\r", dot->getId().c_str());
    
    //logInfo("Test msg \n\r", dot->getId().c_str());
    //logInfo("Test msg \n\r", dot->getId().c_str());
    //logInfo("Test msg \n\r", dot->getId().c_str());
    //logInfo("Test msg \n\r", dot->getId().c_str());   
}

void reset_config(void)
{
    // reset to default config so we know what state we're in
    dot->resetConfig();    
}

void set_log_lavel(int logInfo)
{
    switch(logInfo) {
        case 4:
        dot->setLogLevel(mts::MTSLog::INFO_LEVEL);
        break;
    }   
}

int set_public_network(int value)
{
    return dot->setPublicNetwork(value);
}

int set_frequency_sub_band( int config_frequency_sub_band)
{
     return dot->setFrequencySubBand(config_frequency_sub_band);   
}

int set_network_name(char *config_network_name)
{
    return dot->setNetworkName(config_network_name);  
}

int set_network_passphrase(char *config_network_pass)
{
    return dot->setNetworkPassphrase(config_network_pass);  
}

int set_txpower(int value)
{
    int ret;
    logInfo("setting TX spreading factor");
    if ((ret = dot->setTxPower(value)) != mDot::MDOT_OK) {
        logError("failed to set TX datarate %d:%s", ret);
    }
    return ret;
}

int set_tx_datarate(void)
{
    return dot->setTxDataRate(mDot::SF_10);
}

int set_ack(int value)
{
    return dot->setAck(value);   
}

int save_config(void)
{
    return dot->saveConfig();    
}

int join_network(void)
{  
    int ret;
    while (!dot->getNetworkJoinStatus()) {
        osDelay(dot->getNextTxMs());
        if ((ret = dot->joinNetwork()) != mDot::MDOT_OK) {
            printf("ERROR: failed to join network %d:%s\n\r", ret,  mDot::getReturnCodeString(ret).c_str());
        }
    }
    
    //return dot->joinNetwork();
    return 0;    
}

bool send(const std::string text)
{
    int32_t returnCode;
    uint32_t timeTillSend = dot->getNextTxMs();
    if (timeTillSend != 0) {
        printf("waiting %lu ms to send\r\n", timeTillSend);
        return false;
    }

    //printf("Sending data...  ");
    std::vector<uint8_t> data(text.begin(), text.end());
    if ((returnCode = dot->send(data, 1)) != mDot::MDOT_OK)
    {
        //logInfo("error in sending data");
        return false;
    }
    //printf("Data sent!\r\n");
    return true;
}

/*
int send_data(char *args)
{
    int ret;
    std::vector<uint8_t> data;
    std::string data_str = "hello!";
        // format data for sending to the gateway
    for (std::string::iterator it = data_str.begin(); it != data_str.end(); it++)
        data.push_back((uint8_t) *it);

    while (true) {
        // send the data to the gateway
        if ((ret = dot->send(data)) != mDot::MDOT_OK) {
            logError("failed to send", ret, mDot::getReturnCodeString(ret).c_str());
        } else {
            logInfo("successfully sent data to gateway");
        }

        // in the 868 (EU) frequency band, we need to wait until another channel is available before transmitting again
        osDelay(std::max((uint32_t)5000, (uint32_t)dot->getNextTxMs()));
    }
    return 0;
}
*/

bool receive_data(char *buffer)
{
    std::vector<uint8_t>data;

    if (dot->recv(data) != mDot::MDOT_OK) {
        return false;
    }
    
    int i = 0;
    for (std::vector<uint8_t>::const_iterator it = data.begin(); it != data.end(); ++it)
        buffer[i++] = *it;
    buffer[i] = '\0';

    return true;
}