#include "mbed.h"
#include"Thread.h"
#include "rtos.h"
 Serial pc(USBTX, USBRX); // tx, rx
 
SPI spimaster(SPI1_MOSI, SPI1_MISO, SPI1_SCK);
DigitalOut cs(SPI1_CS);
extern int first_time;
extern int device_buffer[8];
int ble_flag;
extern Mutex my_mutex;
extern int bufferSize;

char data_buf[100];

// reading data from spi 
// spi is communnication between ble and mdot device
void SPI_Init()
{
    pc.baud(9600);
    spimaster.format(8,0);
    spimaster.frequency(1000000);
}
bool recieve_flag = false;
int spi_read(int* response)
{
    //int response[100];
    cs=1;
    //pc.baud(9600);
    printf("...SPI read test ..\n\r ");
    // Chip must be deselected
    cs = 1;
    int temp = 0;
    int size = 0;
    int i = 0;
    printf("Reading Buffer : ");
    while(1)
    {
        // Chip must selected
        cs = 0;
        //int SUCCESS = 1;
        temp = spimaster.write(0xAA);
        cs = 1;
        //printf("Response %X ", temp);

        if(recieve_flag)
        {
            if(temp == 0x20)
            {
                data_buf[size] = ' ';
            }
            else if(temp == 0x2E)
            {
                data_buf[size] = '.';
            }
            else if(temp == 0xFE)
            {
                  printf("buffer size %d\n", bufferSize);
                 data_buf[size] = '\0';
                 printf("data received = %s\n",data_buf);
            }
            else
            {
                if(temp >= 0x30)
                    data_buf[size] = (char)temp;                   
            }
            response[size++] = temp;
        }
        
        if(temp == 0xFE)
        {
            bufferSize = size;
            response[i] = '\0';
            int j = 0;
            size = 0;
            
           

            break;        
        }

        printf("Response %X ", temp);
        //printf("recieve_flag %d ", recieve_flag);
        
        
                        
        if(temp == 0xA0)
        {
            recieve_flag = true;
            size = 0;
        }
        
        
        osDelay(180);
        
        i++;
    }    
    if(ble_flag)
    {
        recieve_flag = false;
        cs = 0;
        spimaster.write(0xAD);
        cs = 1;
    }
    else
    {
        recieve_flag = true;    
    }
    
    return 1;
}

int spi_write(int *buf) 
{
    int response[8];
    
 //   pc.baud(9600);
    printf("SPI test..\n\r");
    //int temp;
    //size = strlen(buf);
    // Chip must be deselected
    
 
    //printf("spi data length is:%d\r\n", size);
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
   // spimaster.format(8,0);
   // spimaster.frequency(1000000);

    int i = 0;
    
    while(i < 5)
    {
        //osDelay(1000);
        // Select the device by seting chip select low
        cs = 0;
        response[i] = spimaster.write(buf[i]);
        
        if(response[i] == 0xFE)
        {
            spimaster.write(0xAF);
        }
        cs = 1;
        printf("buf[i] = %X\r\n", buf[i]);
        printf("response[i] = %X\r\n", response[i]);
        i++;
        //printf("\r\nSlave response = 0x%X, 0x%X, 0x%X, 0x%X", response[0], response[1], response[2], response[3]);       
     }
     
    //printf("master send: %s\r\n", buf);
    //printf("slave response: %s\r\n", response);
    printf("exiting from spi write\r\n");   
    return response[0];
}


void ble_task(void const *args)
{
    printf("started ble task\r\n");
    int ble_buffer[8];
    int i;
    while (true) {
        if (ble_flag) {
            my_mutex.lock();
            for (i = 0; i < 5; i++)
                ble_buffer[i] = device_buffer[i];
            my_mutex.unlock();
            printf("spi write called\r\n");
            spi_write(ble_buffer);
            ble_flag = 0;
        }
        osDelay(1000);    
    }    
}

/*void ble_energymeter(void const *argc)
{
    printf("Starting energymeter ble task \r\n");
    int buff[8];
    while(true)
    {
        if(ble_eflag)
        {
            printf("calling spi read \r\n");
            spi_read(buff);
            ble_eflag = 0;
        }    
        osDelay(1000);
    }
}*/