#include<stdio.h>
#include "mbed.h"
#include "mDot.h"
#include "rtos.h"
#include "wrapper.h"
#include "MTSLog.h"
#include"Thread.h"
//#include"MTSLogs.h"

int spi_write(int *buf);
int spi_read(int *buf);
void zigbee_func(int deviceId,int state);

void ble_task(void const *args);
void zigbee_task(void const *args);

Mutex my_mutex;
//static int flag;
extern int ble_flag;
extern int zigbee_flag;
char gateway_buffer[128];
int device_buffer[8];

int process_gateway_data(const char *device_type, int *device_buffer, char *data_buffer)
{
    const char *pBuf;
    int len;
    int i;
    
    my_mutex.lock();
    for (i = 0; i < 8; i++)
        device_buffer[i] = 0;
    //memset(device_buffer, 0, 8);
    pBuf = strstr(data_buffer, "DeviceType");
    if (!pBuf) {
        printf("device type not found\r\n");
        my_mutex.unlock();
        return false;
    }
        
    pBuf += 13;
       
    len = strstr((const char *)pBuf, ",") - (char *)pBuf - 1; /* ends with / */
    if (len <= 0) {
        my_mutex.unlock();
        return false;
    }
    strncpy ((char *)device_type, (const char *)pBuf, len);
    printf("device type is %s\r\n", device_type);
    if (!strcmp(device_type, "ble_bulbs")) {
        device_buffer[0] = 0xB3;
        device_buffer[1] = 0x01;
        
        pBuf = strstr((const char *)pBuf, "powered");
        if (!pBuf) {
            printf("device action not found\r\n");
            my_mutex.unlock();
            return false;
        }

        pBuf += 9;
        len = strstr((const char *)pBuf, ",") - (char *)pBuf; /* ends with / */
        if (len <= 0) {
            my_mutex.unlock();
            return false;
        }
   
        if (!strncmp ((char *)pBuf, "true", len)) {
            device_buffer[2] = 0x01;
        }
        else if (!strncmp ((char *)pBuf, "false", len)) {
            device_buffer[2] = 0x00;
        }
        else {
            device_buffer[2] = 0x02;
        }
    
        pBuf = strstr((const char *)pBuf, "color");
        if (!pBuf) {
            printf("device color not found\r\n");
            my_mutex.unlock();
            return false;
        }
    
        pBuf += 8;
        len = strstr((const char *)pBuf, ",") - (char *)pBuf - 1; /* ends with / */
        if (len <= 0) {
            my_mutex.unlock();
            return false;
        }
         
        if (!strncmp ((char *)pBuf, "red", len)) {
            device_buffer[3] = 0x00;
        }
        else if (!strncmp ((char *)pBuf, "green", len)) {
            device_buffer[3] = 0x01;
        }
        else if (!strncmp ((char *)pBuf, "blue", len)){
            device_buffer[3] = 0x02;
        }
        else if (!strncmp ((char *)pBuf, "yellow", len)){
            device_buffer[3] = 0x03;
        }
        else if (!strncmp ((char *)pBuf, "cyan", len)){
            device_buffer[3] = 0x04;
        }
        else if (!strncmp ((char *)pBuf, "magenta", len)){
            device_buffer[3] = 0x05;
        }
        else {
            device_buffer[3] = 0x06;
        }
        pBuf = strstr((const char *)pBuf, "dim");
        if (!pBuf) {
            printf("device dim not found\r\n");
            my_mutex.unlock();
            return false;
        }
    
        pBuf += 5;
        device_buffer[4] = atoi(pBuf);
        my_mutex.unlock();
        return true;
    }
    if (!strcmp(device_type, "zigbee")) {
        pBuf = strstr((const char *)pBuf, "DeviceName");
        if (!pBuf) {
            printf("device name not found\r\n");
            my_mutex.unlock();
            return false;
        }
    
        pBuf += 13;
        len = strstr((const char *)pBuf, ",") - (char *)pBuf - 1;
        if (len <= 0) {
            my_mutex.unlock();
            return false;
        }
   
        if (!strncmp ((char *)pBuf, "Light_bulb", len)) {
            device_buffer[0] = 1;
        }
        else if (!strncmp ((char *)pBuf, "Light_lamp", len)) {
            device_buffer[0] = 2;
        }
        else if (!strncmp ((char *)pBuf, "Tv", len)) {
            device_buffer[0] = 3;
        }
        else {
            device_buffer[0] = 4;
        }
    
        pBuf = strstr((const char *)pBuf, "powered");
        if (!pBuf) {
            printf("device action not found\r\n");
            my_mutex.unlock();
            return false;
        }
    
        pBuf += 9;
        len = strstr((const char *)pBuf, ",") - (char *)pBuf; /* ends with / */
        if (len <= 0) {
            my_mutex.unlock();
            return false;
        }
   
        if (!strncmp ((char *)pBuf, "true", len)) {
            device_buffer[1] = 0x01;
        }
        else if (!strncmp ((char *)pBuf, "false", len)) {
            device_buffer[1] = 0x00;
        }
        else {
            device_buffer[1] = 0x02;
        }
        my_mutex.unlock();
        return true;   
    }
    printf("wrong device type\r\n");
    my_mutex.unlock();
    return false;
}

char data_to_gw[100];
int data_from_ble[100];
int bufferSize = 0;

void convertAsciiToChar(int *inBuff, char *outBuff)
{
    for(int i = 0; i < bufferSize; i++)
    {
            if(inBuff[i] == 0x20)
            {
                outBuff[i] = ' ';
            }
            else if(inBuff[i] == 0x2E)
            {
                outBuff[i] = '.';
            }
            else if(inBuff[i] == 0xFE)
            {
                 // printf("buffer size %d\n", bufferSize);
                 outBuff[i] = '\0';
                 printf("data received = %s\n",outBuff);
            }
            else
            {
                if(inBuff[i] >= 0x30)
                    outBuff[i] = (char)inBuff[i];                   
            }
            
        
    }
    return;
}

void send_data_to_gateway(void const *args)
{
    //int light_status;
    //int light_color;
    
    //Thread ble_thread(ble_etask);
   // LogInfo("created thead for ble_Energymeter\r\n");
    //need to form packet to send to gateway before that need to figure out ble reading data
    
    
    logInfo("sending data to gateway"); 
    while (true) {
        if(!ble_flag)
        {
            spi_read(data_from_ble);
            convertAsciiToChar(data_from_ble, data_to_gw);
            printf("********* data %s***********\n",data_to_gw);
            send(data_to_gw);
        }
        osDelay(1000);      
    } 
}

void receive_data_from_gateway(void const *args)
{
    
    int res;
    char device_type[16];
    
    logInfo("receiving data from gateway thread started\r\n");
    
    Thread ble_thread(ble_task);
    Thread zigbee_thread(zigbee_task);
    
    logInfo("created thread for ble and zigbee\r\n");
    
    while(true) {
        
        memset(gateway_buffer, 0, 128);
        send("dummy");
        res = receive_data(gateway_buffer);
        if (res == false) {
            printf("no data received form gateway\r\n");
            osDelay(1000);
            //continue;           
        }
        //strcpy(gateway_buffer, "{\"DeviceType\":\"ble_bulbs\",\"DeviceName\":\"bulb1\",\"DeviceCommand\":\"desired_state\": {\"powered\":true,\"color\":\"red\",\"dim\":50}}");
        printf("data received in mdot from gateway: %s\r\n", gateway_buffer);
       
        memset(device_type, 0, 16);
        res = process_gateway_data(device_type, device_buffer, gateway_buffer);
        if (res == true) {
            printf("device_buffer data is: %X, %X, %X, %X, %d\r\n", device_buffer[0], device_buffer[1], device_buffer[2], device_buffer[3], device_buffer[4]);
            
            if (strcmp(device_type, "ble_bulbs") == 0) {
                printf("sending data to BLE\r\n");
                //spi_write(device_buffer);
                ble_flag = 1;
            }
            else if (strcmp(device_type, "zigbee") == 0) {
                printf("sending data to zigbee\r\n");
                zigbee_flag = 1;
                //zigbee_func(device_buffer[0], device_buffer[1]);
            }
            else {
                printf("wrong device type\r\n");
            }
        }
/*        else {
            printf("error in processing gateway data\r\n");    
        }
*/
        osDelay(1000);
    }   
}