#include "mbed.h"
#include"Thread.h"
#include "rtos.h"
 Serial pc(USBTX, USBRX); // tx, rx
 
SPI spimaster(SPI1_MOSI, SPI1_MISO, SPI1_SCK);
DigitalOut cs(SPI1_CS);
extern int first_time;
extern int device_buffer[8];
int ble_flag;
extern Mutex my_mutex;


// reading data from spi 
// spi is communnication between ble and mdot device
/*
int spi_read(int *buff)
{
    pc.baud(9600);
    printf("...SPI read test ..\n\r ");
    // Chip must be deselected
    cs = 1;
    spi.formate(8,0);
    spimaster.frequency(1000000);
    
    // Chip must selected
    cs = 0;
    int SUCCESS = 1;
    
    //need to figure out how many bytes going to read from ble
    if ( spimaster.read(buff) != SUCCESS)
    {
        printf("reading failed !!!");
        return 0;
    }    
    printf("Reading success read data : %X",buff[0]);
    return 1;
}*/

int spi_write(int *buf) 
{
    int response[8];
   cs = 1; 
    pc.baud(9600);
    printf("SPI test..\n\r");
    //int temp;
    printf("buff[0] = %d\r\n", buf[0]);
    int size = buf[0] + 2;
    printf("size = %d\r\n", size);
    int k, index = 0;
    int write_buff[16];
    // Chip must be deselected
    cs = 1;
    write_buff[index] = 0x86;
    index++;
    for (k =0 ; k< size ; k++, index++)
    {   
        write_buff[index] = buf[k];
         printf("index = %d, size=%d\r\n", index, size);
    }
    
    printf("index = %d, size=%d\r\n", index, size);
    write_buff[index] = 0x88;
   printf("index = %d, size=%d\r\n", index, size);
    printf("index value = %d \r\n", index);
   
    //printf("spi data length is:%d\r\n", size);
    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spimaster.format(8,0);
    spimaster.frequency(1000000);

    int i = 0;
    
    while(i <= index)
    {
        //osDelay(1000);
        // Select the device by seting chip select low
        cs = 0;
        response[i] = spimaster.write(write_buff[i]);
        cs = 1;
        printf("buf[%d] = %X\r\n", i ,write_buff[i]);
        printf("response[%d] = %X\r\n", i , response[i]);
        i++;
        
        //printf("\r\nSlave response = 0x%X, 0x%X, 0x%X, 0x%X", response[0], response[1], response[2], response[3]);       
     }
     
    //printf("master send: %s\r\n", buf);
    //printf("slave response: %s\r\n", response);
    printf("exiting from spi write\r\n");   
    return response[0];
}


void ble_task(void const *args)
{
    printf("started ble task\r\n");
    int ble_buffer[16];
    int i;
    while (true) {
        if (ble_flag) {
            my_mutex.lock();
           // printf("Device buff Length %d \r\n",);
           printf("send Size %d\r\n", device_buffer[0]);
           memset(ble_buffer,'\0', 16);
            for (i = 0; i <= device_buffer[0] + 2; i++)
                ble_buffer[i] = device_buffer[i];
            my_mutex.unlock();
            printf("spi write called\r\n");
            
            spi_write(ble_buffer);
            ble_flag = 0;
        }
        osDelay(1000);    
    }    
}

/*void ble_energymeter(void const *argc)
{
    printf("Starting energymeter ble task \r\n");
    int buff[8];
    while(true)
    {
        if(ble_eflag)
        {
            printf("calling spi read \r\n");
            spi_read(buff);
            ble_eflag = 0;
        }    
        osDelay(1000);
    }
}*/