#include "mbed.h"
#include "mDot.h"
#include "wrapper.h"
#include "MTSLog.h"
#include <string>
#include"Thread.h"
//#include <vector>
//#include <algorithm>

// these options must match the settings on your Conduit
// uncomment the following lines and edit their values to match your configuration
char *config_network_name = "pathfinder";
char *config_network_pass = "pathfinder";
static int config_frequency_sub_band = 7;

//void startLoraTask(void);
//void startZigbeeTask(void);
//void startBLETask(void);

//void loraTask(void const *args);
//void zigbeeTask(void const *args);
//void bleTask(void const *args);

void receive_data_from_gateway(void const *args);
void send_data_to_gateway(void const *args);

int main() 
{
    printf("starting main thread\r\n");
    
    int ret;
    //printf("lora task started\r\n");
    printf("Initializing Lora mdot lib\r\n");   
    init_mdot();
    
    printf("Resetting Lora mdot config\r\n");
    reset_config();
    
    printf("Setting Log info lavel\r\n");
    set_log_lavel(4);
    
    //set_public_network(false);
  
    // set up the mDot with our network information: frequency sub band, network name, and network password
    // these can all be saved in NVM so they don't need to be set every time - see mDot::saveConfig()
    
    // frequency sub band is only applicable in the 915 (US) frequency band
    // if using a MultiTech Conduit gateway, use the same sub band as your Conduit (1-8) - the mDot will use the 8 channels in that sub band
    // if using a gateway that supports all 64 channels, use sub band 0 - the mDot will use all 64 channels
     
    printf("setting frequency sub band %d\r\n", config_frequency_sub_band);
    ret = set_frequency_sub_band(config_frequency_sub_band);
    if (ret < 0) {
        logError("failed to set frequency sub band");
    }
    
    printf("setting network name: %s\r\n", config_network_name);
    ret = set_network_name(config_network_name);
    if (ret < 0) {
        logError("failed to set network name");
    }
    
    printf("setting network password: %s\r\n", config_network_pass);
    ret = set_network_passphrase(config_network_pass);
    if (ret < 0) {
        logError("failed to set network password");
    }
    
    set_txpower(14);
    
    // a higher spreading factor allows for longer range but lower throughput
    // in the 915 (US) frequency band, spreading factors 7 - 10 are available
    // in the 868 (EU) frequency band, spreading factors 7 - 12 are available
    printf("setting TX spreading factor\r\n");
    ret = set_tx_datarate();
    if (ret < 0) {
        logError("failed to set TX datarate");
    }
    
    // request receive confirmation of packets from the gateway
    printf("enabling ACKs\r\n");
    ret = set_ack(true);
    if (ret < 0) {
        logError("failed to enable ACKs");
    }
    
    // save this configuration to the mDot's NVM
    printf("saving config\r\n");
    ret = save_config();
    if (ret < 0) {
        logError("failed to save configuration");
    }
    
    //*******************************************
    // end of configuration
    //*******************************************

    // attempt to join the network
    printf("joining network\r\n");
    ret = join_network();
    /*if (ret < 0) {
        printf("error in join network\r\n");
    }*/
    logInfo("creating thread for sending and receving data from gateway");
  
    Thread send_lora_thread(send_data_to_gateway);
    Thread receive_lora_thread(receive_data_from_gateway);
    
    while(1) {
            osDelay(5000);
    }
    return 0;
}
