/* mbed Microcontroller Library
 * Copyright (c) 2006-2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "ble/BLE.h"
#include "ble/DiscoveredCharacteristic.h"
#include "ble/DiscoveredService.h"
#include "ble/Gap.h"
#include "nRF5xGap.h"
static const uint16_t UNIT_1_25_MS  = 1250;
static const uint16_t UNIT_10_MS  = 10000;
#define MSEC_TO_UNITS(TIME, RESOLUTION) (((TIME) * 1000) / (RESOLUTION))
#define MIN_CONNECTION_INTERVAL   MSEC_TO_UNITS(7.5, UNIT_1_25_MS)
#define MAX_CONNECTION_INTERVAL   MSEC_TO_UNITS(30, UNIT_1_25_MS) 
#define SLAVE_LATENCY             4                            
#define SUPERVISION_TIMEOUT       MSEC_TO_UNITS(6000, UNIT_10_MS) 

typedef unsigned char byte_char;

DiscoveredCharacteristic lightCharacteristic;

static const Gap::ConnectionParams_t m_conn_params ={
    (uint16_t)MIN_CONNECTION_INTERVAL,
    (uint16_t)MAX_CONNECTION_INTERVAL,
    (uint16_t)SLAVE_LATENCY,
    (uint16_t)SUPERVISION_TIMEOUT
};

GapScanningParams m_scan_params;
Serial pc(USBTX, USBRX);

static ble_error_t error_status;

void advertisementCallback(const Gap::AdvertisementCallbackParams_t *params) {
    uint8_t con_status =0;
   // uint8_t i;
    Gap::GapState_t con_state;
     //0x51 for Magic light 
    //0x5A
    if (params->peerAddr[0] != 0x51) { // 0x2F for red bear1.5 /* !ALERT! Alter this filter to suit your device. */
        return; 
    }
    pc.printf("adv peerAddr[%02x %02x %02x %02x %02x %02x] rssi %d, isScanResponse %u, AdvertisementType %u\r\n",
           params->peerAddr[5], params->peerAddr[4], params->peerAddr[3], params->peerAddr[2], params->peerAddr[1], params->peerAddr[0],
           params->rssi, params->isScanResponse, params->type);
           pc.printf("Data Length : %d\r\n",params->advertisingDataLen);
         
        con_status = BLE::Instance().gap().connect(params->peerAddr, Gap::ADDR_TYPE_PUBLIC, NULL, NULL);
        pc.printf("Connection Status : %d\r\n",con_status);
        con_state = BLE::Instance().gap().getState();
        pc.printf("Connection state : %d\r\n",con_state);
    
  //  }
     BLE::Instance().gap().stopScan();
}

void serviceDiscoveryCallback(const DiscoveredService *service) {
    pc.printf("Service Discovery Callback\r\n");
    if (service->getUUID().shortOrLong() == UUID::UUID_TYPE_SHORT) {
        pc.printf("S UUID-%x attrs[%u %u]\r\n", service->getUUID().getShortUUID(), service->getStartHandle(), service->getEndHandle());
    } else {
        pc.printf("S UUID-");
        const uint8_t *longUUIDBytes = service->getUUID().getBaseUUID();
        for (unsigned i = 0; i < UUID::LENGTH_OF_LONG_UUID; i++) {
            printf("%02x", longUUIDBytes[i]);
        }
        pc.printf(" attrs[%u %u]\r\n", service->getStartHandle(), service->getEndHandle());
    }
}

void characteristicDiscoveryCallback(const DiscoveredCharacteristic *characteristicP) {
    pc.printf("  C UUID-%x valueAttr[%u] props[%x]\r\n", characteristicP->getUUID().getShortUUID(), characteristicP->getValueHandle(), (uint8_t)characteristicP->getProperties().broadcast());
    uint8_t write_data []={0x56,0xff,0x00,0x00,0x00,0xf0,0xaa};
    if (characteristicP->getUUID().getShortUUID() == 0xffe9) { /* !ALERT! Alter this filter to suit your device. */
       lightCharacteristic        = *characteristicP;
       pc.printf("Matched char UUID\r\n");
       printf("Value Handle = %d\r\n",characteristicP->getDeclHandle());
       printf("Value Handle = %d and data size : %d\r\n",characteristicP->getValueHandle(),sizeof(write_data));
       lightCharacteristic.writeWoResponse(sizeof(write_data), write_data);
      //error_status = characteristicP->write(sizeof(write_data), write_data);
       printf("Write Status : %d\r\n",error_status);
    }
}

void discoveryTerminationCallback(Gap::Handle_t connectionHandle) {
    pc.printf("terminated SD for handle %u\r\n", connectionHandle);
}

void connectionCallback(const Gap::ConnectionCallbackParams_t *params) {
    pc.printf("Connection Callback\n\r");
    if (params->role == Gap::CENTRAL) {
        pc.printf("Service and characterstics discovery callback\r\n");
        BLE::Instance().gattClient().onServiceDiscoveryTermination(discoveryTerminationCallback);
        BLE::Instance().gattClient().launchServiceDiscovery(params->handle, serviceDiscoveryCallback, characteristicDiscoveryCallback, 0xffe5, 0xffe9);
    }
}

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params) {
    pc.printf("disconnected\r\n");
}


/**
 * Callback triggered when the ble initialization process has finished
 */
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE&        ble   = params->ble;

    pc.printf("Ble Init\n\r");
    /* Ensure that it is the default instance of BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }
 
    ble.gap().onConnection(connectionCallback);
    ble.gap().onDisconnection(disconnectionCallback);
    
    ble.gap().setScanParams(1000, 800);
    ble.gap().startScan(advertisementCallback);
}

int main(void) {
    pc.baud(9600);
    wait(8.0);
    pc.printf("Start\n\r");
    BLE &ble = BLE::Instance();
   
    ble.init(bleInitComplete);
  
    while (true) {
               ble.waitForEvent();
    }
}
