/************************************************************************
*                                                                       *
*                                                                       *
************************************************************************/
#include "mbed.h"
#include "hm_config.h"

DiscoveredCharacteristic lightCharacteristic;
//Gap::Handle_t connectionHandle = 0xFFFF;
//static s_serviceInfo lightChar = {NULL,NULL};
Serial pc(USBTX, USBRX);
void bleint();
void waitBleEvent();
void ble_actions(int spi_data);

uint8_t statusWR;
uint8_t read_buffer[128];
uint8_t nDiscoveredDevice = 0;
static int receiveBufSize = 0;
bool scanFlag = false;
bool response_flag = false;
bool first_connection = true;

SPISlave spiSlave(P0_9, P0_11, P0_8, P0_10);
lightCharacteristic_t ptr_temp_char;


void read_Characteristics();
void AddMacAddress(const uint8_t *u8MacAddress);
void scanThread();
void connectDevices(int device_type);
//DiscoveredCharacteristic ptr_temp_char;

bool connection_handle = 0;

void AddMacAddress(const uint8_t *u8MacAddress)
{
    printf("Add MAC Address::\r\n");
    int i;
    for(i=0; i< MAX_DEVICES; i++)
    {
        if(Ble_address[i][0] == '\0')
        {
            for(unsigned j=0; j< MAX_DEVICES; j++)
            {
                if(Ble_address[j][0] == u8MacAddress[0])
                {
                    printf("Already Added MAC Address \r\n");
                    return;
                }
            }
            memset(Ble_address[i],0,MAC_ADDR_LEN);
            memcpy(Ble_address[i],u8MacAddress,MAC_ADDR_LEN);
            nDiscoveredDevice++;
            if(first_connection && Ble_address[i][0] == DEVICE_MAC_ADDR_1)
            {   
                first_connection = false;
                connectDevices(DEVICE_MAC_ADDR_1);
            }
            printf("MAC Address \r\n");
            for (unsigned index = 0; index < MAC_ADDR_LEN; index++) 
            {
                printf("%02x ", Ble_address[i][index]);
            }
            break;
        }
        else
        {
            printf("MAC Address index[%d] is not NULL \r\n", i);            
        }
    }
    
}

void scanThread()
{
    printf("Scan Thread\r\n");
    
    while(scanFlag)
    {
        wait(10.0);
        scanFlag = false;
        BLE::Instance().gap().stopScan();
    }
    
}

void advertisementCallback(const Gap::AdvertisementCallbackParams_t *params) {

        if (params->peerAddr[0] == DEVICE_MAC_ADDR_1 || params->peerAddr[0] == DEVICE_MAC_ADDR_2 || 
            params->peerAddr[0] == DEVICE_MAC_ADDR_3 || params->peerAddr[0] == DEVICE_MAC_ADDR_4 ||
            params->peerAddr[0] == DEVICE_MAC_ADDR_5)
        { // 0x2F for red bear1.5 /* !ALERT! Alter this filter to suit your device. */
       
           pc.printf("adv peerAddr[%02x %02x %02x %02x %02x %02x] rssi %d, isScanResponse %u, AdvertisementType %u\r\n",
           params->peerAddr[5], params->peerAddr[4], params->peerAddr[3], params->peerAddr[2], params->peerAddr[1], params->peerAddr[0],
           params->rssi, params->isScanResponse, params->type);
           pc.printf("Data Length : %d\r\n",params->advertisingDataLen);
           AddMacAddress(params->peerAddr);
         
        }
        else
        {
            printf("Not Matched your device\r\n");
            return;
        }
 }

void connectDevices(int device_type)
{
         pc.printf("Connection : %d\r\n", disconnect_status);
            pc.printf("Connection device Type: %d\r\n", device_type);
            uint8_t con_status =0;
            for(unsigned index = 0; index < nDiscoveredDevice; index++ )
            {
                if(Ble_address[index][0] == device_type)
                {
                    disconnect_status = false;
                    con_status = BLE::Instance().gap().connect(Ble_address[index], Gap::ADDR_TYPE_PUBLIC, NULL, NULL);
                    pc.printf("Connection Status : %d\r\n",con_status);
                    connect_status = 1;
                    return;
                }
            }

}
void serviceDiscoveryCallback(const DiscoveredService *service) {
    pc.printf("Service Discovery Callback\r\n");
    if (service->getUUID().shortOrLong() == UUID::UUID_TYPE_SHORT) {
        pc.printf("S UUID-%x attrs[%u %u]\r\n", service->getUUID().getShortUUID(), service->getStartHandle(), service->getEndHandle());
    } else {
        //pc.printf("S UUID-");
        const uint8_t *longUUIDBytes = service->getUUID().getBaseUUID();
        for (unsigned i = 0; i < UUID::LENGTH_OF_LONG_UUID; i++) {
            printf("%02x", longUUIDBytes[i]);
        }
        pc.printf(" attrs[%u %u]\r\n", service->getStartHandle(), service->getEndHandle());
    }
}

void characteristicDiscoveryCallback(const DiscoveredCharacteristic *characteristicP) {
    pc.printf("  C UUID-%x valueAttr[%u] props[%x]\r\n", characteristicP->getUUID().getShortUUID(), characteristicP->getValueHandle(), (uint8_t)characteristicP->getProperties().broadcast());
    
    if (characteristicP->getUUID().getShortUUID() == 0xEC0E || characteristicP->getUUID().getShortUUID() == 0xFFE9) { /* !ALERT! Alter this filter to suit your device. */
       lightCharacteristic = *characteristicP;
       pc.printf("Matched char UUID\r\n");
       printf("Conn Handle = %dand %d \r\n",characteristicP->getConnectionHandle(), lightCharacteristic.getConnectionHandle());
       printf("Value Handle = %d and %d\r\n",characteristicP->getValueHandle(),lightCharacteristic.getValueHandle());
       //AddCharNodes(lightCharacteristic);
       charDiscover = 1;
       serviceDiscover = false;
     }else {
        printf("Not Matched char UUID\r\n");
    }
}

void AddCharNodes(DiscoveredCharacteristic light_Characteristic)
{
    //printf("Add Char Nodes\r\n");
    //lightCharacteristic_t ptr_temp_char;
    /*
    ptr_temp_char = lightChar.services_Char[0];

    
    if(NULL == ptr_temp_char)
    {
        ptr_temp_char = new lightCharacteristic_t;
        lightChar.services_Char[0] = ptr_temp_char;         
    }
    else
    {    
        while(NULL != ptr_temp_char->nextChar)
                {
                    ptr_temp_char = ptr_temp_char->nextChar;
                }  
            
        // add a new node 
        ptr_temp_char->nextChar = new lightCharacteristic_t;
        ptr_temp_char = ptr_temp_char->nextChar;
    }*/
            
    /* assign data to the node */
   /* ptr_temp_char.u_characteristicID = 1;
    pc.printf("Conn Handle = %d\r\n",light_Characteristic.getConnectionHandle());
    pc.printf("Value Handle = %d\r\n",light_Characteristic.getValueHandle());
    ptr_temp_char.connHandle = light_Characteristic.getConnectionHandle();
    ptr_temp_char.valueHandle = light_Characteristic.getValueHandle();
    */
    //ptr_temp_char.nextChar = NULL;
}

void discoveryTerminationCallback(Gap::Handle_t connectionHandle) {
    pc.printf("terminated SD for handle %u\r\n", connectionHandle);
    serviceDiscover = false;
    pc.printf("Service Discover handle %d\r\n", serviceDiscover);
}

void connectionCallback(const Gap::ConnectionCallbackParams_t *params) {
    pc.printf("Connection Callback\n\r");
    if (params->role == Gap::CENTRAL) 
    {
        pc.printf("Handle %u and peer addr [%02x]\r\n", params->handle,params->peerAddr[0]);
        pc.printf("Service and characterstics discovery callback\r\n");
        BLE::Instance().gattClient().onServiceDiscoveryTermination(discoveryTerminationCallback);
        switch(params->peerAddr[0])
        {
            case DEVICE_MAC_ADDR_1: // 0xec00 --> Services UUID and 0xec0e --> Characteristics UUID
                error_status = BLE::Instance().gattClient().launchServiceDiscovery(params->handle, serviceDiscoveryCallback, characteristicDiscoveryCallback, 0xEC00, 0xEC0E);
                break;
                    
            case DEVICE_MAC_ADDR_2: // 0xffe5 --> Services UUID and 0xffe9 --> Characteristics UUID
                error_status = BLE::Instance().gattClient().launchServiceDiscovery(params->handle, serviceDiscoveryCallback, characteristicDiscoveryCallback, 0xffe5, 0xffe9);
                break;
            default:
                printf("************Unhandled Device Address *************\r\n");
                break;
        }
        
        printf("Service Discovery Error Status =%d\n\r",error_status);

    }
}

void writeCallback(const GattWriteCallbackParams *eventDataP) 
{
    pc.printf("written callback\r\n");    
}

void pairDevice()
{
    if(read_flag)
    {
        printf("Read Pairdevice\r\n");
        connectDevices(DEVICE_MAC_ADDR_1);
    }
    else if(write_flag)
    {
        printf("Write Pairdevice\r\n");
        connectDevices(DEVICE_MAC_ADDR_2);
    }else
    {
        printf("invalid Pairdevice status\r\n");
    }
}
void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params) {
    pc.printf("disconnected\r\n");
    disconnect_status = true;
    //ble.gap().startScan(advertisementCallback);
    connect_status = 0;
    charDiscover = 0;
    serviceDiscover = true;
    pairDevice();
    //bleint();
}

void triggerRead(const GattReadCallbackParams *response)
{
    printf("reading data : \r\n");
    if (response->handle == lightCharacteristic.getValueHandle())
    {   
        response_flag = true;
        printf("triggerToggledWrite: handle %u, offset %u, len %u\r\n", response->handle, response->offset, response->len);
        memcpy(read_buffer,response->data,response->len);
        receiveBufSize = response->len;
        for (unsigned index = 0; index < response->len; index++) 
        {
            printf("%c", read_buffer[index]);
        }
        printf("\r\n");
    }
}

/**
 * Callback triggered when the ble initialization process has finished
 */
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE&        ble = params->ble;
    
    pc.printf("Ble Init\n\r");
    /* Ensure that it is the default instance of BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }
 
    ble.gap().onConnection(connectionCallback);
    ble.gap().onDisconnection(disconnectionCallback);
    ble.gattClient().onDataRead(triggerRead);
    
    ble.gap().setScanParams(1000, 800);
    ble.gap().startScan(advertisementCallback);
    
    scanFlag = true;
    
}

void read_Characteristics()
{   uint16_t write_data;
    
    error_status = BLE::Instance().gattClient().read(lightCharacteristic.getConnectionHandle(),lightCharacteristic.getValueHandle(), write_data);
    
    printf("Error Status =%d\n\r",error_status);

    printf("READ VALUE : ");
    printf("%x \r\n", write_data);
    BLE::Instance().processEvents();
}
void light_actions(int * service_char)
{
    uint8_t write_data[16];

    uint8_t numCount;
    if(connect_status)
    {

        switch(service_char[2])
        {
            case TURN_OFF: // off 
                write_data[0]=0x56;
                write_data[1]=0x00;
                write_data[2]=0x00;
                write_data[3]=0x00;
                write_data[4]=0x00;
                write_data[5]=0xf0;
                write_data[6]=0xaa;
                
                error_status = BLE::Instance().gattClient().write(GattClient::GATT_OP_WRITE_CMD,lightCharacteristic.getConnectionHandle(),lightCharacteristic.getValueHandle(),7,write_data);
                BLE::Instance().processEvents();
                break;
                       
            case TURN_ON: //on
                if(first_on)
                {
                    pre_write_data[0]=0x56;
                    pre_write_data[1]=0xDE;
                    pre_write_data[2]=0x8E;
                    pre_write_data[3]=0xEE;
                    pre_write_data[4]=0x00;
                    pre_write_data[5]=0xf0;
                    pre_write_data[6]=0xaa;
                }
                error_status = BLE::Instance().gattClient().write(GattClient::GATT_OP_WRITE_CMD,lightCharacteristic.getConnectionHandle(),lightCharacteristic.getValueHandle(),7,pre_write_data);
                BLE::Instance().processEvents();
                break;
                       
            case COLOR: // Color
                write_data[0]=0x56;
                write_data[1]=lightColor[service_char[3]][0];//0xff
                write_data[2]=lightColor[service_char[3]][1];//0x00;
                write_data[3]=lightColor[service_char[3]][2];//0x00;
                write_data[4]=0x00;
                write_data[5]=0xf0;
                write_data[6]=0xaa;
                for(numCount=0; numCount < 7; numCount++){
                  pre_write_data[numCount] = write_data[numCount];
                }
                first_on=false;
                error_status = BLE::Instance().gattClient().write(GattClient::GATT_OP_WRITE_CMD,lightCharacteristic.getConnectionHandle(),lightCharacteristic.getValueHandle(),7,write_data);
                BLE::Instance().processEvents();
                break;
                       
            default:
                printf("Invalid Options\r\n");
        } 
            printf(" light Error Status =%d\n\r",error_status);
    }

}

void datancpy(char pre_write[], char writeData[], int data_size){
    int numCount;
    for(numCount=0; numCount <= data_size; numCount++){
        pre_write[numCount] = writeData[numCount];
    }
    
}

void bleint()
{
    printf("Init\r\n");
    BLE &ble = BLE::Instance();
    BLE::Instance().init(bleInitComplete);
    
}

bool checkBytes(int byteValue)
{    
    
    bool status = false;
    switch(byteValue)
    {
        case 0xAD:
            read_flag = false;
            write_flag = true;
            BLE::Instance().gap().disconnect(lightCharacteristic.getConnectionHandle(),Gap::REMOTE_USER_TERMINATED_CONNECTION);
            status = true;
            break;
        
        case 0xAF:
            read_flag = true;
            write_flag = false;
            BLE::Instance().gap().disconnect(lightCharacteristic.getConnectionHandle(),Gap::REMOTE_USER_TERMINATED_CONNECTION);
            status = true;
            break;
            
        default:
            status = false;
            break;
    }
    
    return status;
}

int main()
{
    // Serial port configuration
    pc.baud(9600);
    wait(8.0);
    pc.printf("Start\n\r");
    statusWR=1;

    int read_temp_data;
    int write_temp_data;
    uint8_t read_bufferSize;
    
    bleint();
    
    spiSlave.reply(12);

    read_bufferSize = 0;
    while(1)
    {
        pc.printf("loop\r\n");
        printf( "Connect Status %d  and Char Discover %d \r\n", connect_status, charDiscover);
        
        scanThread();
        
        if(!(connect_status && charDiscover))
        {   
            printf( " Wait Event Connect Status %d  and Char Discover %d \r\n", connect_status, charDiscover);
            waitBleEvent();
            
        }
        printf("Readchar\r\n");
      
        if(connect_status && charDiscover)
        {
            //read_bufferSize = 0;
            if(read_flag)
            {
                pc.printf("Read\r\n");
                read_Characteristics();
                printf("receiveBufSize : %d",receiveBufSize);
                if(spiSlave.receive()  && response_flag)//
                {   
                    
                    read_temp_data = spiSlave.read();
                          
                    while(spiSlave.receive()) 
                    {   
                        if(read_bufferSize == 0)  
                            spiSlave.reply(receiveBufSize);
                            
                        //if(read_bufferSize < receiveBufSize)
                         //   break;
                        
                        //vif(checkBytes(read_temp_data))
                         //v   break;
                            
                        read_temp_data = spiSlave.read();
                        if(read_temp_data == 0xAA)
                        {
                            spiSlave.reply(read_buffer[read_bufferSize]);
                            read_bufferSize++;   
                        }
                        
                        
                        
                    }
                
                    if(read_bufferSize >= receiveBufSize)
                    {
                        read_bufferSize =0;
                        spiSlave.reply(0xFE);// Send 0xFE to Master to indicate stop polling the data.
                    }        
                }
            }
            if(write_flag && connect_status && charDiscover)
            {
                if(spiSlave.receive())
                {
                    spiRX[write_bufferSize] = spiSlave.read();
                    write_temp_data = spiRX[write_bufferSize];
                    write_bufferSize = 0;
                    while(write_flag)
                    {
                        if(checkBytes(write_temp_data))
                            break;
                            
                        spiSlave.reply(spiRX[write_bufferSize]);
                        write_bufferSize++;
                        spiRX[write_bufferSize] = spiSlave.read();
                        write_temp_data = spiRX[write_bufferSize];
                        
                        if(write_bufferSize >= 5 )
                        {
                            light_actions(spiRX);
                            spiSlave.reply(0xFE); // Send 0xFE to Master to indicate stop polling the data.
                              
                        }
                    }
                }
            }
        }  
    }

}

void waitBleEvent()
{
    while(serviceDiscover )
    {
        printf("Service Discover =%d\r\n",serviceDiscover);
        printf(" Service Status = %d \r\n",BLE::Instance().gattClient().isServiceDiscoveryActive());
        BLE::Instance().waitForEvent();
        printf( "waitBleEvent loop\r\n");
    }
    printf( "waitBleEvent End\r\n"); 
}

