

#ifndef __HM_CONFIG_H__
#define __HM_CONFIG_H__

#include "mbed.h"
#include "ble/BLE.h"
#include "ble/DiscoveredCharacteristic.h"
#include "ble/DiscoveredService.h"
#include "ble/Gap.h"

#define MAX_SERVICES 4
#define DEVICE_MAC_ADDR_1   0xE5 //Raspberry PI
#define DEVICE_MAC_ADDR_2   0x51 //Magic Light1
#define DEVICE_MAC_ADDR_3   0x5A //Magic Light2
#define DEVICE_MAC_ADDR_4   0x4F //MiniBeacon_22824
#define DEVICE_MAC_ADDR_5   0xE6 //MiniBeacon_22829
#define MAX_DEVICES         5

static const size_t MAC_ADDR_LEN = 6;

//class Magic_Light{
bool connect_status = false;
bool charDiscover =  false;

uint8_t pre_write_data[16];
int spiRX[8];
uint8_t write_bufferSize;
uint8_t write_data[16];

static ble_error_t error_status;
bool serviceDiscover = true;
bool first_on=true;

bool read_flag = true;
bool write_flag = false;
bool disconnect_status = true;
void AddCharNodes(DiscoveredCharacteristic light_Characteristic);
void light_actions(int service_char[]);

//public:
typedef enum light_action_e{
    TURN_OFF=0, 
    TURN_ON,
    COLOR,
    INVAILD
}light_action;

typedef enum light_color_e{
    RED=0,
    GREEN,
    BLUE,
    YELLOW,
    CYAN,
    MAGENTA,
    MAX_COLOR
}light_color;


uint8_t lightColor[MAX_COLOR][3] = {{0xFF,0x00,0x00},{0x00,0xFF,0x00},
                                    {0x00,0x00,0xFF},{0xFF,0xFF,0x00},
                                    {0x00,0xFF,0xFF},{0xFF,0x00,0xFF}
                                   };


uint8_t Ble_address[MAX_DEVICES][MAC_ADDR_LEN];

struct lightCharacteristic_t{
    uint8_t DeviceID;
    uint8_t Ble_address[MAC_ADDR_LEN];
    DiscoveredCharacteristic DiscoverCharacteristics;
    //struct lightCharacteristic_t *nextChar;
};

typedef struct _serviceinfo 
{
    lightCharacteristic_t * services_Char[MAX_SERVICES];

}s_serviceInfo;

//};

#endif /* ifndef __BLE_H__ */