/************************************************************************
*                                                                       *
*                                                                       *
************************************************************************/

#include "hm_config.h"

DiscoveredCharacteristic lightCharacteristic;
//Gap::Handle_t connectionHandle = 0xFFFF;
//static s_serviceInfo lightChar = {NULL,NULL};
Serial pc(USBTX, USBRX);
void bleint();
void waitBleEvent();
void ble_actions(int spi_data);
uint8_t statusWR;
SPISlave spiSlave(P0_9, P0_11, P0_8, P0_10);
lightCharacteristic_t ptr_temp_char;


void read_Characteristics();

//DiscoveredCharacteristic ptr_temp_char;

bool connection_handle = 0;

uint8_t Ble_address[6];


void advertisementCallback(const Gap::AdvertisementCallbackParams_t *params) {
    uint8_t con_status =0;
    int i;
     //0x51 for Magic light 
    //0x5A
    
        /*pc.printf("adv peerAddr[%02x %02x %02x %02x %02x %02x] rssi %d, isScanResponse %u, AdvertisementType %u\r\ndata: %s\r\n",
           params->peerAddr[5], params->peerAddr[4], params->peerAddr[3], params->peerAddr[2], params->peerAddr[1], params->peerAddr[0],
           params->rssi, params->isScanResponse, params->type, params->advertisingData);*/
        //if (params->peerAddr[0] == 0x5A){ // 0x2F for red bear1.5 /* !ALERT! Alter this filter to suit your device. */
        if (params->peerAddr[0] == 0xE5){ // 0x2F for red bear1.5 /* !ALERT! Alter this filter to suit your device. */
       
           pc.printf("adv peerAddr[%02x %02x %02x %02x %02x %02x] rssi %d, isScanResponse %u, AdvertisementType %u\r\n",
           params->peerAddr[5], params->peerAddr[4], params->peerAddr[3], params->peerAddr[2], params->peerAddr[1], params->peerAddr[0],
           params->rssi, params->isScanResponse, params->type);
           pc.printf("Data Length : %d\r\n",params->advertisingDataLen);
            for (i = 0; i < 6; i++)
                Ble_address[i] = params->peerAddr[i];
                
           con_status = BLE::Instance().gap().connect(params->peerAddr, Gap::ADDR_TYPE_PUBLIC, NULL, NULL);
           pc.printf("Connection Status : %d\r\n",con_status);
           connect_status = 1;
           BLE::Instance().gap().stopScan();
          
        }
        else{
            printf("Not Matched your device\r\n");
            return;
        }
 }

void serviceDiscoveryCallback(const DiscoveredService *service) {
    pc.printf("Service Discovery Callback\r\n");
    if (service->getUUID().shortOrLong() == UUID::UUID_TYPE_SHORT) {
        pc.printf("S UUID-%x attrs[%u %u]\r\n", service->getUUID().getShortUUID(), service->getStartHandle(), service->getEndHandle());
    } else {
        //pc.printf("S UUID-");
        const uint8_t *longUUIDBytes = service->getUUID().getBaseUUID();
        for (unsigned i = 0; i < UUID::LENGTH_OF_LONG_UUID; i++) {
            printf("%02x", longUUIDBytes[i]);
        }
        pc.printf(" attrs[%u %u]\r\n", service->getStartHandle(), service->getEndHandle());
    }
}

void characteristicDiscoveryCallback(const DiscoveredCharacteristic *characteristicP) {
    pc.printf("  C UUID-%x valueAttr[%u] props[%x]\r\n", characteristicP->getUUID().getShortUUID(), characteristicP->getValueHandle(), (uint8_t)characteristicP->getProperties().broadcast());
    
    if (characteristicP->getUUID().getShortUUID() == 0xEC0E) { /* !ALERT! Alter this filter to suit your device. */
       lightCharacteristic = *characteristicP;
       pc.printf("Matched char UUID\r\n");
       printf("Conn Handle = %dand %d \r\n",characteristicP->getConnectionHandle(), lightCharacteristic.getConnectionHandle());
       printf("Value Handle = %d and %d\r\n",characteristicP->getValueHandle(),lightCharacteristic.getValueHandle());
       AddCharNodes(lightCharacteristic);
       charDiscover = 1;
       serviceDiscover = false;
     }else {
        printf("Not Matched char UUID\r\n");
    }
}

void AddCharNodes(DiscoveredCharacteristic light_Characteristic)
{
    //printf("Add Char Nodes\r\n");
    //lightCharacteristic_t ptr_temp_char;
    /*
    ptr_temp_char = lightChar.services_Char[0];

    
    if(NULL == ptr_temp_char)
    {
        ptr_temp_char = new lightCharacteristic_t;
        lightChar.services_Char[0] = ptr_temp_char;         
    }
    else
    {    
        while(NULL != ptr_temp_char->nextChar)
                {
                    ptr_temp_char = ptr_temp_char->nextChar;
                }  
            
        // add a new node 
        ptr_temp_char->nextChar = new lightCharacteristic_t;
        ptr_temp_char = ptr_temp_char->nextChar;
    }*/
            
    /* assign data to the node */
    ptr_temp_char.u_characteristicID = 1;
    pc.printf("Conn Handle = %d\r\n",light_Characteristic.getConnectionHandle());
    pc.printf("Value Handle = %d\r\n",light_Characteristic.getValueHandle());
    ptr_temp_char.connHandle = light_Characteristic.getConnectionHandle();
    ptr_temp_char.valueHandle = light_Characteristic.getValueHandle();
    //ptr_temp_char.nextChar = NULL;
}

void discoveryTerminationCallback(Gap::Handle_t connectionHandle) {
    pc.printf("terminated SD for handle %u\r\n", connectionHandle);
    serviceDiscover = false;
    pc.printf("Service Discover handle %d\r\n", serviceDiscover);
}

void connectionCallback(const Gap::ConnectionCallbackParams_t *params) {
    pc.printf("Connection Callback\n\r");
    if (params->role == Gap::CENTRAL) {
        //connectionHandle = params->handle;
        pc.printf("Handle %u\r\n", params->handle);
        pc.printf("Service and characterstics discovery callback\r\n");
        BLE::Instance().gattClient().onServiceDiscoveryTermination(discoveryTerminationCallback);
        error_status = BLE::Instance().gattClient().launchServiceDiscovery(params->handle, serviceDiscoveryCallback, characteristicDiscoveryCallback, 0xEC00, 0xEC0E);
        printf("Service Discovery Error Status =%d\n\r",error_status);
        // 0xffe5 --> Services UUID
        // 0xffe9 --> Characteristics UUID
    }
}

void writeCallback(const GattWriteCallbackParams *eventDataP) 
{
    pc.printf("written callback\r\n");    
}

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params) {
    pc.printf("disconnected\r\n");
    //ble.gap().startScan(advertisementCallback);
    connect_status = 0;
    charDiscover = 0;
    bleint();
}


void hvxCallback(const GattHVXCallbackParams *params) {
    printf("received HVX callback for handle %u; type %s\r\n", params->handle, (params->type == BLE_HVX_NOTIFICATION) ? "notification" : "indication");
    for (unsigned index = 0; index < params->len; index++) {
        printf(" %02x", params->data[index]);
    }
    printf("\r\n");
}
void triggerRead(const GattReadCallbackParams *response)
{
    printf("reading data : \r\n");
   // if (response->handle == GattCharacteristic.getValueHandle()) 
  //  if (response->handle == characteristicP->getValueHandle())
    {
        printf("triggerToggledWrite: handle %u, offset %u, len %u\r\n", response->handle, response->offset, response->len);
        for (unsigned index = 0; index < response->len; index++) 
        {
            printf("%c[%02x]", response->data[index], response->data[index]);
        }
        printf("\r\n");
    }
}

/**
 * Callback triggered when the ble initialization process has finished
 */
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params)
{
    BLE&        ble = params->ble;
    
    pc.printf("Ble Init\n\r");
    /* Ensure that it is the default instance of BLE */
    if(ble.getInstanceID() != BLE::DEFAULT_INSTANCE) {
        return;
    }
 
    ble.gap().onConnection(connectionCallback);
    ble.gap().onDisconnection(disconnectionCallback);
    ble.gap().setScanParams(1000, 800);
    ble.gap().startScan(advertisementCallback);
    //ble.gattClient().onHVX(hvxCallback);
    //ble.gattClient().onDataRead(triggerRead);

}

void write_Characteristics()
{   uint8_t write_data  = 0x45;
    
    error_status = BLE::Instance().gattClient().write(GattClient::GATT_OP_WRITE_REQ, ptr_temp_char.connHandle,ptr_temp_char.valueHandle, sizeof(write_data), &write_data);
    
    printf("Error Status =%d\n\r",error_status);
    //int i;
    printf("write VALUE : ");
    //for(i=0; i<16;i++)
    //{
        printf("%d \r\n", write_data);
    //}
    BLE::Instance().processEvents();
}

void read_Characteristics()
{   uint16_t write_data;
    
    error_status = BLE::Instance().gattClient().read(ptr_temp_char.connHandle,ptr_temp_char.valueHandle, write_data);
    
    printf("Error Status =%d\n\r",error_status);
    //int i;
    printf("READ VALUE : ");
    //for(i=0; i<16;i++)
    //{
        printf("%x \r\n", write_data);
    //}
    BLE::Instance().processEvents();
}
void light_actions(int * service_char)
{

/*
    uint8_t lightColor[MAX_COLOR][3] = {{0xFF,0x00,0x00},{0x00,0xFF,0x00},
                                    {0x00,0x00,0xFF},{0xFF,0xFF,0x00},
                                    {0x00,0xFF,0xFF},{0xFF,0x00,0xFF}
                                   };
    uint8_t pre_write_data[16];
    uint8_t write_data[16];
    
    //lightCharacteristic_t *ptr_tmp = NULL;
    //ptr_tmp = lightChar.services_Char[0];
    uint8_t numCount;
    if(connect_status)
    {

        switch(service_char[2])
        {
            case TURN_OFF: // off 
                write_data[0]=0x56;
                write_data[1]=0x00;
                write_data[2]=0x00;
                write_data[3]=0x00;
                write_data[4]=0x00;
                write_data[5]=0xf0;
                write_data[6]=0xaa;
                //error_status = BLE::Instance().gattClient().write(GattClient::GATT_OP_WRITE_CMD,ptr_tmp->connHandle,ptr_tmp->valueHandle,8,write_data);
                error_status = BLE::Instance().gattClient().write(GattClient::GATT_OP_WRITE_CMD,connectionHandle,ptr_temp_char.valueHandle,7,write_data);
                BLE::Instance().processEvents();
                //error_status = BLE::Instance().gattClient().write(GattClient::GATT_OP_WRITE_CMD,ptr_temp_char.connHandle,ptr_temp_char.valueHandle,7,write_data);
                 //BLE::Instance().updateCharacteristicValue(rxCharacteristic.getValueAttribute().getHandle(), write_data, 7);
                break;
                       
            case TURN_ON: //on
                pre_write_data[0]=0x56;
                pre_write_data[1]=0xDE;
                pre_write_data[2]=0x8E;
                pre_write_data[3]=0xEE;
                pre_write_data[4]=0x00;
                pre_write_data[5]=0xf0;
                pre_write_data[6]=0xaa;
                
                //error_status = BLE::Instance().gattClient().write(GattClient::GATT_OP_WRITE_CMD,ptr_tmp->connHandle,ptr_tmp->valueHandle,8,pre_write_data);
                error_status = BLE::Instance().gattClient().write(GattClient::GATT_OP_WRITE_CMD,connectionHandle,ptr_temp_char.valueHandle,7,pre_write_data);
                BLE::Instance().processEvents();
                //error_status = BLE::Instance().DiscoveredCharacteristic().write(7,pre_write_data);
                break;
                       
            case COLOR: // Color
                write_data[0]=0x56;
                write_data[1]=lightColor[service_char[3]][0];//0xff
                write_data[2]=lightColor[service_char[3]][1];//0x00;
                write_data[3]=lightColor[service_char[3]][2];//0x00;
                write_data[4]=0x00;
                write_data[5]=0xf0;
                write_data[6]=0xaa;
                for(numCount=0; numCount < 7; numCount++){
                  pre_write_data[numCount] = write_data[numCount];
                }
                first_on=false;
                //error_status = BLE::Instance().gattClient().write(GattClient::GATT_OP_WRITE_CMD,ptr_tmp->connHandle,ptr_tmp->valueHandle,8,write_data);
                error_status = BLE::Instance().gattClient().write(GattClient::GATT_OP_WRITE_CMD,connectionHandle,ptr_temp_char.valueHandle,7,write_data);
                BLE::Instance().processEvents();
                //error_status = BLE::Instance().gattClient().write(GattClient::GATT_OP_WRITE_CMD,ptr_temp_char.connHandle,ptr_temp_char.valueHandle,7,write_data);
                
                break;
                       
            default:
                printf("Invalid Options\r\n");
        } 
            printf("Error Status =%d\n\r",error_status);
    }
*/
}

void datancpy(char pre_write[], char writeData[], int data_size){
    int numCount;
    for(numCount=0; numCount <= data_size; numCount++){
        pre_write[numCount] = writeData[numCount];
    }
    
}

void bleint()
{
    printf("Init\r\n");
    BLE &ble = BLE::Instance();
    BLE::Instance().init(bleInitComplete);
}

int main()
{
    // Serial port configuration
    pc.baud(9600);
    wait(8.0);
    pc.printf("Start\n\r");

    //spiSlave.reply(191);
    statusWR=1;
    bleint();
    bufferSize = 0;
    /*int spiRX[5];
    
    int temp = 0x00;
    int color = 0x00;
    int con_status,i;*/
    while(1){
        pc.printf("loop\r\n");
        //wait(1.0);
        printf( "Connect Status %d  and Char Discover %d \r\n", connect_status, charDiscover);
        if(!(connect_status && charDiscover))
        {
            printf( " Wait Event Connect Status %d  and Char Discover %d \r\n", connect_status, charDiscover);
            waitBleEvent();
        }
        printf("Readchar\r\n");
        if(connect_status && charDiscover)
        {
            pc.printf("Read\r\n");
            
            write_Characteristics();
            wait(2.0);
            read_Characteristics();
        }
           
        /* 
        if (temp == 2 && color == 3) {
            temp = 0x00;
            color = 0x00;
        }
        else if (temp == 2 && color < 3) {
            color++;
        }
        else if (temp < 2)
            temp++;
            
         spiRX[0] = 0xB3;
         spiRX[1] = 1; 
         spiRX[2] = temp;
         spiRX[3] = color;
         pc.printf("spix buffer is: ");
        for (i = 0; i < 4; i++) {
                pc.printf("%d ", spiRX[i]);
        }
        pc.printf("\n");

        //if(spiSlave.receive()){
             //printf("Slave Read loop1\r\n");
            //spiRX[bufferSize] = spiSlave.read();
            //spiSlave.reply(spiRX[bufferSize]);
            //bufferSize++;
            bufferSize = 5;
            
            if(bufferSize >= 5){
                bufferSize=0;
                light_actions(spiRX);
                //BLE::Instance().gattClient().reset();
                spiSlave.reply(spiRX[2]); //(0xAA);
               
                
                if(error_status > 7)
                {
                    error_status = BLE_ERROR_NONE;
                    //wait_ms(500);
                    BLE::Instance().shutdown();
                    statusWR =1;
                    connect_status =0;
                    charDiscover =0;
                    serviceDiscover = true;
                    bleint();
                }
                //statusWR++;
                 wait_ms(3000);
            }
            
        //}  */   
        
    }

}

void waitBleEvent()
{
    //|| BLE::Instance().gattClient().isServiceDiscoveryActive()
    while(serviceDiscover ){
                    printf("Service Discover =%d\r\n",serviceDiscover);
                    printf(" Service Status = %d \r\n",BLE::Instance().gattClient().isServiceDiscoveryActive());
                    BLE::Instance().waitForEvent();
                    printf( "waitBleEvent loop\r\n");
    }
    printf( "waitBleEvent End\r\n"); 
}

